/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable.gui;

import com.google.common.base.Predicates;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.api.client.gui.subgui.IGuiInputElementValueType;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntry;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntryListener;
import org.cyclops.integrateddynamics.core.evaluate.variable.gui.GuiElementValueTypeDropdownListClient;
import org.cyclops.integrateddynamics.core.evaluate.variable.gui.GuiElementValueTypeDropdownListRenderPattern;

public class GuiElementValueTypeDropdownList<T, G extends Screen, C extends AbstractContainerMenu>
implements IGuiInputElementValueType<GuiElementValueTypeDropdownListRenderPattern, G, C, GuiElementValueTypeDropdownListClient<T, G, C>>,
IDropdownEntryListener<T> {
    private final IValueType valueType;
    private Predicate<IValue> validator;
    private final IConfigRenderPattern renderPattern;
    private String inputString;
    private Set<IDropdownEntry<T>> dropdownPossibilities = Collections.emptySet();
    private IDropdownEntryListener<T> dropdownEntryListener = null;

    public GuiElementValueTypeDropdownList(IValueType valueType, IConfigRenderPattern renderPattern) {
        this.valueType = valueType;
        this.validator = Predicates.alwaysTrue();
        this.renderPattern = renderPattern;
    }

    @Override
    public void setValidator(Predicate<IValue> validator) {
        this.validator = validator;
    }

    @Override
    public void setValue(IValue value) {
        throw new UnsupportedOperationException("This method has not been implemented yet");
    }

    @Override
    public IValue getValue() {
        throw new UnsupportedOperationException("This method has not been implemented yet");
    }

    @Override
    public GuiElementValueTypeDropdownListClient<T, G, C> getClient() {
        return new GuiElementValueTypeDropdownListClient(this);
    }

    @Override
    public Component getName() {
        return Component.translatable((String)this.getValueType().getTranslationKey());
    }

    @Override
    public void loadTooltip(Consumer<Component> tooltipAdder) {
        this.getValueType().loadTooltip(tooltipAdder, true, null);
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return this.renderPattern;
    }

    @Override
    public void activate() {
        this.inputString = "";
    }

    @Override
    public void deactivate() {
        this.inputString = null;
    }

    @Override
    public Component validate() {
        try {
            Object value = this.getValueType().parseString(this.inputString);
            if (!this.validator.test((IValue)value)) {
                return Component.translatable((String)"valuetype.integrateddynamics.error.value");
            }
        }
        catch (EvaluationException e) {
            return e.getErrorMessage();
        }
        return null;
    }

    @Override
    public int getColor() {
        return this.getValueType().getDisplayColor();
    }

    @Override
    public String getSymbol() {
        return IModHelpers.get().getL10NHelpers().localize(this.getValueType().getTranslationKey(), new Object[0]);
    }

    @Override
    public void onSetDropdownPossiblity(IDropdownEntry dropdownEntry) {
        if (this.dropdownEntryListener != null) {
            this.dropdownEntryListener.onSetDropdownPossiblity(dropdownEntry);
        }
    }

    public IValueType getValueType() {
        return this.valueType;
    }

    public Predicate<IValue> getValidator() {
        return this.validator;
    }

    public String getInputString() {
        return this.inputString;
    }

    public Set<IDropdownEntry<T>> getDropdownPossibilities() {
        return this.dropdownPossibilities;
    }

    public IDropdownEntryListener<T> getDropdownEntryListener() {
        return this.dropdownEntryListener;
    }

    public void setInputString(String inputString) {
        this.inputString = inputString;
    }

    public void setDropdownPossibilities(Set<IDropdownEntry<T>> dropdownPossibilities) {
        this.dropdownPossibilities = dropdownPossibilities;
    }

    public void setDropdownEntryListener(IDropdownEntryListener<T> dropdownEntryListener) {
        this.dropdownEntryListener = dropdownEntryListener;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GuiElementValueTypeDropdownList)) {
            return false;
        }
        GuiElementValueTypeDropdownList other = (GuiElementValueTypeDropdownList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IValueType this$valueType = this.getValueType();
        IValueType other$valueType = other.getValueType();
        if (this$valueType == null ? other$valueType != null : !this$valueType.equals(other$valueType)) {
            return false;
        }
        Predicate<IValue> this$validator = this.getValidator();
        Predicate<IValue> other$validator = other.getValidator();
        if (this$validator == null ? other$validator != null : !this$validator.equals(other$validator)) {
            return false;
        }
        IConfigRenderPattern this$renderPattern = this.getRenderPattern();
        IConfigRenderPattern other$renderPattern = other.getRenderPattern();
        if (this$renderPattern == null ? other$renderPattern != null : !this$renderPattern.equals(other$renderPattern)) {
            return false;
        }
        String this$inputString = this.getInputString();
        String other$inputString = other.getInputString();
        if (this$inputString == null ? other$inputString != null : !this$inputString.equals(other$inputString)) {
            return false;
        }
        Set<IDropdownEntry<T>> this$dropdownPossibilities = this.getDropdownPossibilities();
        Set<IDropdownEntry<T>> other$dropdownPossibilities = other.getDropdownPossibilities();
        if (this$dropdownPossibilities == null ? other$dropdownPossibilities != null : !((Object)this$dropdownPossibilities).equals(other$dropdownPossibilities)) {
            return false;
        }
        IDropdownEntryListener<T> this$dropdownEntryListener = this.getDropdownEntryListener();
        IDropdownEntryListener<T> other$dropdownEntryListener = other.getDropdownEntryListener();
        return !(this$dropdownEntryListener == null ? other$dropdownEntryListener != null : !this$dropdownEntryListener.equals(other$dropdownEntryListener));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GuiElementValueTypeDropdownList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IValueType $valueType = this.getValueType();
        result = result * 59 + ($valueType == null ? 43 : $valueType.hashCode());
        Predicate<IValue> $validator = this.getValidator();
        result = result * 59 + ($validator == null ? 43 : $validator.hashCode());
        IConfigRenderPattern $renderPattern = this.getRenderPattern();
        result = result * 59 + ($renderPattern == null ? 43 : $renderPattern.hashCode());
        String $inputString = this.getInputString();
        result = result * 59 + ($inputString == null ? 43 : $inputString.hashCode());
        Set<IDropdownEntry<T>> $dropdownPossibilities = this.getDropdownPossibilities();
        result = result * 59 + ($dropdownPossibilities == null ? 43 : ((Object)$dropdownPossibilities).hashCode());
        IDropdownEntryListener<T> $dropdownEntryListener = this.getDropdownEntryListener();
        result = result * 59 + ($dropdownEntryListener == null ? 43 : $dropdownEntryListener.hashCode());
        return result;
    }

    public String toString() {
        return "GuiElementValueTypeDropdownList(valueType=" + String.valueOf(this.getValueType()) + ", validator=" + String.valueOf(this.getValidator()) + ", renderPattern=" + String.valueOf(this.getRenderPattern()) + ", inputString=" + this.getInputString() + ", dropdownPossibilities=" + String.valueOf(this.getDropdownPossibilities()) + ", dropdownEntryListener=" + String.valueOf(this.getDropdownEntryListener()) + ")";
    }
}

