/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network.diagnostics;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.cyclops.integrateddynamics.core.network.diagnostics.IRawData;
import org.cyclops.integrateddynamics.core.network.diagnostics.RawObserverData;
import org.cyclops.integrateddynamics.core.network.diagnostics.RawPartData;

public class RawNetworkData
implements IRawData {
    private final boolean killed;
    private final int id;
    private final int cables;
    private final List<RawPartData> parts;
    private final List<RawObserverData> observers;

    public String toString() {
        return String.format("Network %s (cables: %s; elements: %s)", this.id, this.cables, this.parts.size());
    }

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("killed", this.killed);
        tag.putInt("id", this.id);
        tag.putLong("cables", (long)this.cables);
        ListTag listParts = new ListTag();
        for (RawPartData part : this.parts) {
            listParts.add((Object)part.toNbt());
        }
        tag.put("parts", (Tag)listParts);
        ListTag listObservers = new ListTag();
        for (RawObserverData observer : this.observers) {
            listObservers.add((Object)observer.toNbt());
        }
        tag.put("observers", (Tag)listObservers);
        return tag;
    }

    public static RawNetworkData fromNbt(CompoundTag tag) {
        ArrayList parts = Lists.newArrayList();
        ListTag listParts = (ListTag)tag.getList("parts").orElseThrow();
        for (int i = 0; i < listParts.size(); ++i) {
            CompoundTag partTag = (CompoundTag)listParts.getCompound(i).orElseThrow();
            parts.add(RawPartData.fromNbt(partTag));
        }
        ArrayList observers = Lists.newArrayList();
        ListTag listObservers = (ListTag)tag.getList("observers").orElseThrow();
        for (int i = 0; i < listObservers.size(); ++i) {
            CompoundTag observerTag = (CompoundTag)listObservers.getCompound(i).orElseThrow();
            observers.add(RawObserverData.fromNbt(observerTag));
        }
        return new RawNetworkData((Boolean)tag.getBoolean("killed").orElseThrow(), (Integer)tag.getInt("id").orElseThrow(), (Integer)tag.getInt("cables").orElseThrow(), parts, observers);
    }

    public RawNetworkData(boolean killed, int id, int cables, List<RawPartData> parts, List<RawObserverData> observers) {
        this.killed = killed;
        this.id = id;
        this.cables = cables;
        this.parts = parts;
        this.observers = observers;
    }

    public boolean isKilled() {
        return this.killed;
    }

    public int getId() {
        return this.id;
    }

    public int getCables() {
        return this.cables;
    }

    public List<RawPartData> getParts() {
        return this.parts;
    }

    public List<RawObserverData> getObservers() {
        return this.observers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawNetworkData)) {
            return false;
        }
        RawNetworkData other = (RawNetworkData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isKilled() != other.isKilled()) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getCables() != other.getCables()) {
            return false;
        }
        List<RawPartData> this$parts = this.getParts();
        List<RawPartData> other$parts = other.getParts();
        if (this$parts == null ? other$parts != null : !((Object)this$parts).equals(other$parts)) {
            return false;
        }
        List<RawObserverData> this$observers = this.getObservers();
        List<RawObserverData> other$observers = other.getObservers();
        return !(this$observers == null ? other$observers != null : !((Object)this$observers).equals(other$observers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RawNetworkData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isKilled() ? 79 : 97);
        result = result * 59 + this.getId();
        result = result * 59 + this.getCables();
        List<RawPartData> $parts = this.getParts();
        result = result * 59 + ($parts == null ? 43 : ((Object)$parts).hashCode());
        List<RawObserverData> $observers = this.getObservers();
        result = result * 59 + ($observers == null ? 43 : ((Object)$observers).hashCode());
        return result;
    }
}

