/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.display;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.neoforged.neoforge.fluids.FluidStack;

public record RecipeDisplayDryingBasin(SlotDisplay inputIngredient, FluidStack inputFluid, SlotDisplay outputItem, FluidStack outputFluid, SlotDisplay craftingStation, int duration) implements RecipeDisplay
{
    public static final MapCodec<RecipeDisplayDryingBasin> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SlotDisplay.CODEC.fieldOf("input_ingredient").forGetter(RecipeDisplayDryingBasin::inputIngredient), (App)FluidStack.CODEC.fieldOf("input_fluid").forGetter(RecipeDisplayDryingBasin::inputFluid), (App)SlotDisplay.CODEC.fieldOf("output_ingredient").forGetter(RecipeDisplayDryingBasin::outputItem), (App)FluidStack.CODEC.fieldOf("output_fluid").forGetter(RecipeDisplayDryingBasin::outputFluid), (App)SlotDisplay.CODEC.fieldOf("crafting_station").forGetter(RecipeDisplayDryingBasin::craftingStation), (App)Codec.INT.fieldOf("duration").forGetter(RecipeDisplayDryingBasin::duration)).apply((Applicative)instance, RecipeDisplayDryingBasin::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, RecipeDisplayDryingBasin> STREAM_CODEC = StreamCodec.composite((StreamCodec)SlotDisplay.STREAM_CODEC, RecipeDisplayDryingBasin::inputIngredient, (StreamCodec)FluidStack.OPTIONAL_STREAM_CODEC, RecipeDisplayDryingBasin::inputFluid, (StreamCodec)SlotDisplay.STREAM_CODEC, RecipeDisplayDryingBasin::outputItem, (StreamCodec)FluidStack.OPTIONAL_STREAM_CODEC, RecipeDisplayDryingBasin::outputFluid, (StreamCodec)SlotDisplay.STREAM_CODEC, RecipeDisplayDryingBasin::craftingStation, (StreamCodec)ByteBufCodecs.VAR_INT, RecipeDisplayDryingBasin::duration, RecipeDisplayDryingBasin::new);
    public static final RecipeDisplay.Type<RecipeDisplayDryingBasin> TYPE = new RecipeDisplay.Type(MAP_CODEC, STREAM_CODEC);

    public SlotDisplay result() {
        if (this.outputItem() == SlotDisplay.Empty.INSTANCE) {
            FluidStack fluidStack = this.outputFluid();
            return new SlotDisplay.ItemSlotDisplay(this.outputFluid().getFluidType().getBucket(fluidStack).getItem());
        }
        return this.outputItem();
    }

    public RecipeDisplay.Type<? extends RecipeDisplay> type() {
        return TYPE;
    }

    public boolean isEnabled(FeatureFlagSet featureFlagSet) {
        return this.inputIngredient.isEnabled(featureFlagSet) && this.outputItem().isEnabled(featureFlagSet) && super.isEnabled(featureFlagSet);
    }
}

