/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.advancement.criterion;

import java.util.Optional;
import org.cyclops.integrateddynamics.api.advancement.criterion.ValuePredicate;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;

public class VariablePredicate<V extends IVariable> {
    public static final VariablePredicate ANY = new VariablePredicate<IVariable>(IVariable.class, Optional.empty(), Optional.empty());
    private final Class<V> variableClass;
    private final Optional<IValueType> valueType;
    private final Optional<ValuePredicate> valuePredicate;

    public VariablePredicate(Class<V> variableClass, Optional<IValueType> valueType, Optional<ValuePredicate> valuePredicate) {
        this.variableClass = variableClass;
        this.valueType = valueType;
        this.valuePredicate = valuePredicate;
    }

    public Optional<IValueType> getValueType() {
        return this.valueType;
    }

    public Optional<ValuePredicate> getValuePredicate() {
        return this.valuePredicate;
    }

    public final boolean test(IVariable variable) {
        try {
            return this.variableClass.isInstance(variable) && (this.valueType.isEmpty() || ValueHelpers.correspondsTo(this.valueType.get(), variable.getType())) && this.valuePredicate.orElse(ValuePredicate.ANY).test((IValue)variable.getValue()) && this.testTyped(variable);
        }
        catch (EvaluationException e) {
            return false;
        }
    }

    protected boolean testTyped(V variable) {
        return true;
    }
}

