/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.integrateddynamics.blockentity.BlockEntityDryingBasin;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class RenderBlockEntityDryingBasin
implements BlockEntityRenderer<BlockEntityDryingBasin> {
    public RenderBlockEntityDryingBasin(BlockEntityRendererProvider.Context context) {
    }

    public void render(BlockEntityDryingBasin tile, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLight, int combinedOverlay, Vec3 cameraPos) {
        if (tile != null) {
            if (!tile.getInventory().getItem(0).isEmpty()) {
                matrixStack.pushPose();
                matrixStack.translate(-0.5f, -0.5f, -0.5f);
                this.renderItem(matrixStack, renderTypeBuffer, tile.getInventory().getItem(0), tile.getRandomRotation(), tile.getLevel());
                matrixStack.popPose();
            }
            FluidStack fluid = tile.getTank().getFluid();
            IModHelpersNeoForge.get().getRenderHelpers().renderFluidContext(fluid, matrixStack, () -> {
                float height = (float)((double)fluid.getAmount() * 0.7 / (double)IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume() + 0.23 + 0.01);
                int brightness = Math.max(combinedLight, fluid.getFluid().getFluidType().getLightLevel(fluid));
                int l2 = brightness >> 16 & 0xFFFF;
                int i3 = brightness & 0xFFFF;
                TextureAtlasSprite icon = IModHelpersNeoForge.get().getRenderHelpers().getFluidIcon(fluid, Direction.UP);
                IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
                Triple color = IModHelpers.get().getBaseHelpers().intToRGB(renderProperties.getTintColor(fluid));
                VertexConsumer vb = renderTypeBuffer.getBuffer(RenderType.text((ResourceLocation)icon.atlasLocation()));
                Matrix4f matrix = matrixStack.last().pose();
                vb.addVertex(matrix, 0.0625f, height, 0.0625f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU0(), icon.getV1()).setUv2(l2, i3);
                vb.addVertex(matrix, 0.0625f, height, 0.9375f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU0(), icon.getV0()).setUv2(l2, i3);
                vb.addVertex(matrix, 0.9375f, height, 0.9375f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU1(), icon.getV0()).setUv2(l2, i3);
                vb.addVertex(matrix, 0.9375f, height, 0.0625f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU1(), icon.getV1()).setUv2(l2, i3);
            });
        }
    }

    private void renderItem(PoseStack matrixStack, MultiBufferSource renderTypeBuffer, ItemStack itemStack, float rotation, Level level) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        ItemStackRenderState renderState = new ItemStackRenderState();
        Minecraft.getInstance().getItemModelResolver().updateForTopItem(renderState, itemStack, ItemDisplayContext.FIXED, level, null, 0);
        if (renderState.isOversizedInGui()) {
            matrixStack.translate(1.0f, 1.2f, 1.0f);
            matrixStack.scale(1.2f, 1.2f, 1.2f);
        } else {
            matrixStack.translate(1.0f, 1.2f, 1.0f);
            matrixStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(25.0f));
            matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(25.0f));
            matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(rotation));
        }
        itemRenderer.renderStatic(itemStack, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.NO_OVERLAY, matrixStack, renderTypeBuffer, level, 0);
    }
}

