/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.blockentity.BlockEntityDryingBasin;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeDouble;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.gametest.GameTestHelpersIntegratedDynamics;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public class GameTestsAspectsReadFluid {
    public static final String TEMPLATE_EMPTY = "integrateddynamics:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadFluidFullTrue(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin dryingBasin = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        dryingBasin.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 1000));
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.FLUID_READER, Aspects.Read.Fluid.BOOLEAN_FULL, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadFluidFullFalse(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin dryingBasin = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        dryingBasin.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 10));
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.FLUID_READER, Aspects.Read.Fluid.BOOLEAN_FULL, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadFluidEmptyTrue(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin dryingBasin = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.FLUID_READER, Aspects.Read.Fluid.BOOLEAN_EMPTY, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadFluidEmptyFalse(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin dryingBasin = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        dryingBasin.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 10));
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.FLUID_READER, Aspects.Read.Fluid.BOOLEAN_EMPTY, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadFluidNonEmptyTrue(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin dryingBasin = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        dryingBasin.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 10));
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.FLUID_READER, Aspects.Read.Fluid.BOOLEAN_NONEMPTY, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadFluidNonEmptyFalse(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin dryingBasin = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.FLUID_READER, Aspects.Read.Fluid.BOOLEAN_NONEMPTY, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadFluidApplicableTrue(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.FLUID_READER, Aspects.Read.Fluid.BOOLEAN_APPLICABLE, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadFluidApplicableFalse(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.FLUID_READER, Aspects.Read.Fluid.BOOLEAN_APPLICABLE, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadFluidAmount(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin dryingBasin = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        dryingBasin.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 10));
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.FLUID_READER, Aspects.Read.Fluid.INTEGER_AMOUNT, ValueTypeInteger.ValueInteger.of(10));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadFluidAmountTotal(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin dryingBasin = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        dryingBasin.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 10));
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.FLUID_READER, Aspects.Read.Fluid.INTEGER_AMOUNTTOTAL, ValueTypeInteger.ValueInteger.of(10));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadFluidCapacityValid(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.FLUID_READER, Aspects.Read.Fluid.INTEGER_CAPACITY, ValueTypeInteger.ValueInteger.of(1000));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadFluidCapacityInvalid(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.FLUID_READER, Aspects.Read.Fluid.INTEGER_CAPACITY, ValueTypeInteger.ValueInteger.of(0));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadFluidCapacityTotalValid(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.FLUID_READER, Aspects.Read.Fluid.INTEGER_CAPACITYTOTAL, ValueTypeInteger.ValueInteger.of(1000));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadFluidCapacityTotalInvalid(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.FLUID_READER, Aspects.Read.Fluid.INTEGER_CAPACITYTOTAL, ValueTypeInteger.ValueInteger.of(0));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadFluidTanksValid(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.FLUID_READER, Aspects.Read.Fluid.INTEGER_TANKS, ValueTypeInteger.ValueInteger.of(1));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadFluidTanksInvalid(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.FLUID_READER, Aspects.Read.Fluid.INTEGER_TANKS, ValueTypeInteger.ValueInteger.of(1));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadFluidFillRatio(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin dryingBasin = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        dryingBasin.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 500));
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.FLUID_READER, Aspects.Read.Fluid.DOUBLE_FILLRATIO, ValueTypeDouble.ValueDouble.of(0.5));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadFluidTankFluids(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin dryingBasin = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        dryingBasin.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 500));
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.FLUID_READER, Aspects.Read.Fluid.LIST_TANKFLUIDS, ValueTypeList.ValueList.ofAll((IValue[])new ValueObjectTypeFluidStack.ValueFluidStack[]{ValueObjectTypeFluidStack.ValueFluidStack.of(new FluidStack((Fluid)Fluids.WATER, 500))}));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadFluidTankCapacities(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin dryingBasin = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        dryingBasin.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 500));
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.FLUID_READER, Aspects.Read.Fluid.LIST_TANKCAPACITIES, ValueTypeList.ValueList.ofAll((IValue[])new ValueTypeInteger.ValueInteger[]{ValueTypeInteger.ValueInteger.of(1000)}));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadFluidFluidStack(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin dryingBasin = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        dryingBasin.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 500));
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.FLUID_READER, Aspects.Read.Fluid.FLUIDSTACK, ValueObjectTypeFluidStack.ValueFluidStack.of(new FluidStack((Fluid)Fluids.WATER, 500)));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadFluidBlockValid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.WATER);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.FLUID_READER, Aspects.Read.Fluid.BLOCK, ValueObjectTypeFluidStack.ValueFluidStack.of(new FluidStack((Fluid)Fluids.WATER, 1000)));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadFluidBlockInvalid(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.FLUID_READER, Aspects.Read.Fluid.BLOCK, ValueObjectTypeFluidStack.ValueFluidStack.of(FluidStack.EMPTY));
    }
}

