/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.infobook.pageelement;

import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.infobook.AdvancedButtonEnum;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.RecipeAppendix;
import org.cyclops.cyclopscore.infobook.pageelement.RecipeAppendixClient;
import org.cyclops.integrateddynamics.core.recipe.display.RecipeDisplaySqueezer;
import org.cyclops.integrateddynamics.infobook.pageelement.SqueezerRecipeAppendix;

public class SqueezerRecipeAppendixClient
extends RecipeAppendixClient<SqueezerRecipeAppendix> {
    protected static final int SLOT_SIZE = 16;

    public SqueezerRecipeAppendixClient(SqueezerRecipeAppendix appendix) {
        super((RecipeAppendix)appendix);
    }

    public void bakeElement(InfoSection infoSection) {
        Map renderItemHolders = ((SqueezerRecipeAppendix)this.getSectionAppendix()).getRenderItemHolders();
        IInfoBook infoBook = ((SqueezerRecipeAppendix)this.getSectionAppendix()).getInfoBook();
        renderItemHolders.put(SqueezerRecipeAppendix.INPUT_ITEM, new RecipeAppendixClient.ItemButton(infoBook));
        for (AdvancedButtonEnum resultItem : ((SqueezerRecipeAppendix)this.getSectionAppendix()).getResultItems()) {
            renderItemHolders.put(resultItem, new RecipeAppendixClient.ItemButton(infoBook));
        }
        renderItemHolders.put(SqueezerRecipeAppendix.RESULT_FLUID, new RecipeAppendixClient.FluidButton(infoBook));
    }

    public void drawElementInner(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, int width, int height, int page, int mx, int my) {
        int middle = (width - 16) / 2;
        gui.drawArrowRight(guiGraphics, x + middle - 3, y + 2);
        RecipeDisplayEntry recipeDisplay = ((SqueezerRecipeAppendix)this.getSectionAppendix()).getRecipeDisplay();
        if (recipeDisplay == null) {
            return;
        }
        int tick = this.getTick(gui);
        ContextMap contextMap = SlotDisplayContext.fromLevel((Level)Minecraft.getInstance().level);
        RecipeDisplaySqueezer display = (RecipeDisplaySqueezer)recipeDisplay.display();
        ItemStack inputItem = this.prepareItemStacks(display.inputIngredient().resolveForStacks(contextMap), tick);
        List<ItemStack> outputItems = display.outputItems().stream().map(pair -> ((SlotDisplay)pair.getLeft()).resolveForFirstStack(contextMap)).toList();
        FluidStack outputFluid = display.outputFluid();
        this.renderItem(gui, guiGraphics, x + 16, y, inputItem, mx, my, SqueezerRecipeAppendix.INPUT_ITEM);
        int slotOffset = 0;
        for (int i = 0; i < outputItems.size(); ++i) {
            this.renderItem(gui, guiGraphics, x + 68, y + slotOffset, outputItems.get(i), mx, my, ((SqueezerRecipeAppendix)this.getSectionAppendix()).getResultItems().get(i), ((Float)display.outputItems().get(i).getRight()).floatValue());
            slotOffset += 23;
        }
        if (!outputFluid.isEmpty()) {
            this.renderFluid(gui, guiGraphics, x + 68, y + slotOffset, outputFluid, mx, my, SqueezerRecipeAppendix.RESULT_FLUID);
        }
        this.renderItem(gui, guiGraphics, x + middle, y, ((SqueezerRecipeAppendix)this.getSectionAppendix()).getCrafter(), mx, my, false, null);
    }
}

