/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.item;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.Consumables;
import net.minecraft.world.item.consume_effects.ApplyStatusEffectsConsumeEffect;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.ComposterBlock;
import org.cyclops.cyclopscore.config.ConfigurablePropertyCommon;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfigCommon;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;

public class ItemMenrilBerriesConfig
extends ItemConfigCommon<IModBase> {
    @ConfigurablePropertyCommon(category="item", comment="If the berries should give the night vision effect when eaten.", requiresMcRestart=true)
    public static boolean nightVision = true;

    public ItemMenrilBerriesConfig() {
        super((IModBase)IntegratedDynamics._instance, "menril_berries", (eConfig, properties) -> new Item(properties.food(ItemMenrilBerriesConfig.createFood(), ItemMenrilBerriesConfig.createConsumable())));
    }

    protected static FoodProperties createFood() {
        return new FoodProperties.Builder().nutrition(4).saturationModifier(0.3f).build();
    }

    protected static Consumable createConsumable() {
        Consumable.Builder builder = Consumables.defaultFood().consumeSeconds(0.8f);
        if (nightVision) {
            builder = builder.onConsume((ConsumeEffect)new ApplyStatusEffectsConsumeEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 20, 1), 1.0f));
        }
        return builder.build();
    }

    public void onRegistryRegistered() {
        super.onRegistryRegistered();
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)this.getInstance()), 0.65f);
    }
}

