/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.loot.functions;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import org.cyclops.cyclopscore.RegistryEntries;
import org.cyclops.integrateddynamics.blockentity.BlockEntityMechanicalSqueezer;

public class LootFunctionCopyMechanicalSqueezerTank
extends LootItemConditionalFunction {
    public static final MapCodec<LootFunctionCopyMechanicalSqueezerTank> CODEC = RecordCodecBuilder.mapCodec(builder -> LootFunctionCopyMechanicalSqueezerTank.commonFields((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, LootFunctionCopyMechanicalSqueezerTank::new));
    public static final LootItemFunctionType<LootFunctionCopyMechanicalSqueezerTank> TYPE = new LootItemFunctionType(CODEC);

    protected LootFunctionCopyMechanicalSqueezerTank(List<LootItemCondition> conditionsIn) {
        super(conditionsIn);
    }

    public ItemStack run(ItemStack itemStack, LootContext lootContext) {
        BlockEntity tile = (BlockEntity)lootContext.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (tile instanceof BlockEntityMechanicalSqueezer) {
            itemStack.set((Supplier)RegistryEntries.COMPONENT_FLUID_CONTENT, (Object)SimpleFluidContent.copyOf((FluidStack)((BlockEntityMechanicalSqueezer)tile).getTank().getFluid()));
        }
        return itemStack;
    }

    public LootItemFunctionType getType() {
        return TYPE;
    }
}

