/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.client.model.DynamicItemAndBlockModel;
import org.cyclops.cyclopscore.client.model.IDynamicModelElementCommon;
import org.cyclops.cyclopscore.config.extendedconfig.BlockClientConfig;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfigCommon;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.client.model.CableModel;
import org.cyclops.integrateddynamics.core.client.model.ItemModelCable;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;

public class BlockCableClientConfig
extends BlockClientConfig<IntegratedDynamics> {
    public static TextureAtlasSprite BLOCK_TEXTURE;

    public BlockCableClientConfig(BlockConfigCommon<IntegratedDynamics> blockConfig) {
        super(blockConfig);
        ((IntegratedDynamics)blockConfig.getMod()).getModEventBus().addListener(this::onRegisterColors);
        ((IntegratedDynamics)blockConfig.getMod()).getModEventBus().addListener(this::registerClientExtensions);
        ((IntegratedDynamics)blockConfig.getMod()).getModEventBus().addListener(this::postTextureStitch);
        ((IntegratedDynamics)blockConfig.getMod()).getModEventBus().addListener(event -> event.register(ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"cable"), ItemModelCable.Unbaked.MAP_CODEC));
    }

    public void onRegisterColors(RegisterColorHandlersEvent.Block event) {
        event.register((net.minecraft.client.color.block.BlockColor)new BlockColor(), new Block[]{(Block)this.getBlockConfig().getInstance()});
    }

    public void postTextureStitch(TextureAtlasStitchedEvent event) {
        if (event.getAtlas().location().equals((Object)TextureAtlas.LOCATION_BLOCKS)) {
            BLOCK_TEXTURE = event.getAtlas().getSprite(ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"block/cable"));
        }
    }

    public void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerBlock(new IClientBlockExtensions(this){

            public boolean addHitEffects(BlockState blockState, Level world, HitResult target, ParticleEngine particleManager) {
                BlockPos blockPos = ((BlockHitResult)target).getBlockPos();
                if (CableHelpers.hasFacade((ILevelExtension)world, blockPos, blockState)) {
                    CableHelpers.getFacade((ILevelExtension)world, blockPos, blockState).ifPresent(facadeState -> IModHelpers.get().getRenderHelpers().addBlockHitEffects(particleManager, (ClientLevel)world, facadeState, blockPos, ((BlockHitResult)target).getDirection()));
                    return true;
                }
                return false;
            }
        }, new Block[]{(Block)this.getBlockConfig().getInstance()});
    }

    @Nullable
    public IDynamicModelElementCommon getDynamicModelElement() {
        return new DynamicModel();
    }

    public static class BlockColor
    implements net.minecraft.client.color.block.BlockColor {
        public int getColor(BlockState blockState, @Nullable BlockAndTintGetter world, @Nullable BlockPos blockPos, int color) {
            int n;
            if (blockPos == null || !(world instanceof ILevelExtension)) {
                n = -1;
            } else {
                ILevelExtension levelExtension = (ILevelExtension)world;
                n = CableHelpers.getFacade(levelExtension, blockPos, blockState).map(facadeState -> Minecraft.getInstance().getBlockColors().getColor(facadeState, world, blockPos, color)).orElse(-1);
            }
            return n;
        }
    }

    public static class DynamicModel
    implements IDynamicModelElementCommon {
        public BlockStateModel createDynamicBlockModel(Consumer<Pair<BlockState, BlockStateModel>> modelConsumer, Function<BlockState, BlockStateModel> modelRetriever) {
            CableModel model = new CableModel();
            modelConsumer.accept((Pair<BlockState, BlockStateModel>)Pair.of((Object)((BlockCable)((Object)RegistryEntries.BLOCK_CABLE.get())).defaultBlockState(), (Object)((Object)model)));
            modelConsumer.accept((Pair<BlockState, BlockStateModel>)Pair.of((Object)((BlockState)((BlockCable)((Object)RegistryEntries.BLOCK_CABLE.get())).defaultBlockState().setValue((Property)BlockCable.WATERLOGGED, (Comparable)Boolean.valueOf(true))), (Object)((Object)model)));
            return model;
        }

        public ItemModel createDynamicItemModel(Consumer<Pair<ResourceLocation, ItemModel>> modelConsumer, Function<ResourceLocation, ItemModel> modelRetriever) {
            ItemModelCable model = new ItemModelCable((DynamicItemAndBlockModel)new CableModel());
            ResourceLocation registryName = BuiltInRegistries.BLOCK.getKey((Object)((Block)RegistryEntries.BLOCK_CABLE.get()));
            modelConsumer.accept((Pair<ResourceLocation, ItemModel>)Pair.of((Object)registryName, (Object)model));
            return model;
        }
    }
}

