/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.gui.container;

import com.google.common.collect.Lists;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonImage;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.cyclopscore.client.gui.image.Image;
import org.cyclops.cyclopscore.helper.IGuiHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.integrateddynamics.core.client.gui.ContainerScreenMechanicalMachine;
import org.cyclops.integrateddynamics.inventory.container.ContainerMechanicalSqueezer;

public class ContainerScreenMechanicalSqueezer
extends ContainerScreenMechanicalMachine<ContainerMechanicalSqueezer> {
    private final IImage imageArrowDownEnabled;
    private final IImage imageArrowDownDisabled;
    private ButtonImage buttonToggleFluidEject;

    public ContainerScreenMechanicalSqueezer(ContainerMechanicalSqueezer container, Inventory inventory, Component title) {
        super(container, inventory, title);
        this.imageArrowDownEnabled = new Image(this.texture, 176, 138, 20, 10);
        this.imageArrowDownDisabled = new Image(this.texture, 176, 148, 20, 10);
    }

    protected ResourceLocation constructGuiTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"textures/gui/mechanical_squeezer.png");
    }

    public void init() {
        super.init();
        this.buttonToggleFluidEject = new ButtonImage(this.getGuiLeftTotal() + 149, this.getGuiTopTotal() + 71, (Component)Component.translatable((String)"gui.integrateddynamics.mechanical_squeezer.fluidautoeject"), this.createServerPressable("button_eject", button -> {}), this.imageArrowDownDisabled);
        this.addRenderableWidget((GuiEventListener)this.buttonToggleFluidEject);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.buttonToggleFluidEject.setImage(((ContainerMechanicalSqueezer)this.getMenu()).isAutoEjectFluids() ? this.imageArrowDownEnabled : this.imageArrowDownDisabled);
        IModHelpers.get().getGuiHelpers().renderProgressBar(guiGraphics, this.getGuiTexture(), this.getGuiLeftTotal() + 73, this.getGuiTopTotal() + 36, 12, 18, 176, 120, IGuiHelpers.ProgressDirection.DOWN, ((ContainerMechanicalSqueezer)this.getMenu()).getProgress(), ((ContainerMechanicalSqueezer)this.getMenu()).getMaxProgress());
        IModHelpers.get().getGuiHelpers().renderProgressBar(guiGraphics, this.getGuiTexture(), this.getGuiLeftTotal() + 8, this.getGuiTopTotal() + 16, 18, 60, 176, 60, IGuiHelpers.ProgressDirection.UP, ((ContainerMechanicalSqueezer)this.getMenu()).getEnergy(), ((ContainerMechanicalSqueezer)this.getMenu()).getMaxEnergy());
        IModHelpersNeoForge.get().getGuiHelpers().renderOverlayedFluidTank(guiGraphics, ((ContainerMechanicalSqueezer)this.getMenu()).getFluidStack(), ((ContainerMechanicalSqueezer)this.getMenu()).getFluidCapacity(), this.getGuiLeftTotal() + 150, this.getGuiTopTotal() + 10, 18, 60, this.texture, 176, 0);
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        this.drawEnergyBarTooltip(guiGraphics, 8, 16, 18, 60, mouseX, mouseY);
        this.drawFluidTankTooltip(guiGraphics, ((ContainerMechanicalSqueezer)this.getMenu()).getFluidStack(), ((ContainerMechanicalSqueezer)this.getMenu()).getFluidCapacity(), 150, 10, 18, 60, mouseX, mouseY);
        IModHelpers.get().getGuiHelpers().renderTooltip((AbstractContainerScreen)this, guiGraphics, 150, 70, 18, 10, mouseX, mouseY, () -> Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"gui.integrateddynamics.mechanical_squeezer.togglefluidautoeject", (Object[])new Object[]{String.valueOf(ChatFormatting.AQUA) + IModHelpers.get().getL10NHelpers().localize(((ContainerMechanicalSqueezer)this.getMenu()).isAutoEjectFluids() ? "general.integrateddynamics.true" : "general.integrateddynamics.false", new Object[0])}), Component.translatable((String)"gui.integrateddynamics.mechanical_squeezer.togglefluidautoeject.info")}));
    }
}

