/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.gui.container;

import java.awt.Rectangle;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectWrite;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.api.part.write.IPartTypeWriter;
import org.cyclops.integrateddynamics.core.client.gui.container.ContainerScreenMultipartAspects;
import org.cyclops.integrateddynamics.inventory.container.ContainerPartWriter;

public class ContainerScreenPartWriter<P extends IPartTypeWriter<P, S>, S extends IPartStateWriter<P>>
extends ContainerScreenMultipartAspects<P, S, IAspectWrite<?, ?>, ContainerPartWriter<P, S>> {
    private static final int ERROR_X = 152;
    private static final int ERROR_Y = 20;
    private static final int OK_X = 152;
    private static final int OK_Y = 20;

    public ContainerScreenPartWriter(ContainerPartWriter<P, S> container, Inventory inventory, Component title) {
        super(container, inventory, title);
    }

    @Override
    protected String getNameId() {
        return "part_writer";
    }

    @Override
    protected void drawAdditionalElementInfoForeground(GuiGraphics guiGraphics, ContainerPartWriter<P, S> container, int index, IAspectWrite<?, ?> aspect, int mouseX, int mouseY) {
        if (((ContainerPartWriter)this.getMenu()).isPartStateEnabled()) {
            this.displayErrors.drawForeground(guiGraphics, ((ContainerPartWriter)this.getMenu()).getAspectErrors(aspect), 152, 20 + container.getAspectBoxHeight() * index, mouseX, mouseY, (ContainerScreenExtended<?>)this, this.leftPos, this.topPos);
        }
    }

    @Override
    protected void drawAdditionalElementInfo(GuiGraphics guiGraphics, ContainerPartWriter<P, S> container, int index, IAspectWrite<?, ?> aspect) {
        int aspectBoxHeight = container.getAspectBoxHeight();
        ItemStack itemStack = container.writeAspectInfo(false, new ItemStack(RegistryEntries.ITEM_VARIABLE), container.getPlayerIInventory().player.level(), aspect);
        Rectangle pos = this.getElementPosition(container, index, true);
        guiGraphics.renderItem(itemStack, pos.x, pos.y);
        if (((ContainerPartWriter)this.getMenu()).isPartStateEnabled()) {
            this.displayErrors.drawBackground(guiGraphics, ((ContainerPartWriter)this.getMenu()).getAspectErrors(aspect), 152, 20 + aspectBoxHeight * index, 152, 20 + aspectBoxHeight * index, (ContainerScreenExtended<?>)this, this.leftPos, this.topPos, ((ContainerPartWriter)this.getMenu()).getPartStateActiveAspect() == aspect);
        }
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        ContainerPartWriter container = (ContainerPartWriter)this.getMenu();
        IModHelpers.get().getRenderHelpers().drawScaledCenteredString(guiGraphics, this.font, container.getWriteValue().getString(), this.leftPos + this.offsetX + 53, this.topPos + this.offsetY + 132, 70, ARGB.opaque((int)container.getWriteValueColor()), false, Font.DisplayMode.NORMAL);
    }

    protected int getBaseXSize() {
        return 195;
    }

    protected int getBaseYSize() {
        return 222;
    }

    @Override
    public int getMaxLabelWidth() {
        return 85;
    }
}

