/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.color.item.Constant;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.item.ItemFacade;
import org.jetbrains.annotations.Nullable;

public class FacadeModel
implements ItemModel {
    private final ItemModel emptyModel;
    private final ModelRenderProperties modelrenderproperties;

    public FacadeModel(ItemModel emptyModel, ModelRenderProperties modelrenderproperties) {
        this.emptyModel = emptyModel;
        this.modelrenderproperties = modelrenderproperties;
    }

    public void update(ItemStackRenderState renderState, ItemStack itemStack, ItemModelResolver itemModelResolver, ItemDisplayContext displayContext, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
        BlockState blockState = ((ItemFacade)((Object)RegistryEntries.ITEM_FACADE.get())).getFacadeBlock(itemStack);
        if (blockState == null) {
            this.emptyModel.update(renderState, itemStack, itemModelResolver, displayContext, level, entity, seed);
        } else {
            BlockStateModel bakedModel = IModHelpers.get().getRenderHelpers().getBakedModel(blockState);
            ArrayList quads = Lists.newArrayList();
            for (BlockModelPart collectPart : bakedModel.collectParts((BlockAndTintGetter)level, BlockPos.ZERO, blockState, RandomSource.create((long)seed))) {
                for (Direction direction : Direction.values()) {
                    quads.addAll(collectPart.getQuads(direction));
                }
            }
            new BlockModelWrapper(List.of(new Constant(-1)), (List)quads, this.modelrenderproperties).update(renderState, itemStack, itemModelResolver, displayContext, level, entity, seed);
        }
    }
}

