/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.valuetype;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.api.client.render.valuetype.IValueTypeWorldRenderer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;

public class ItemValueTypeWorldRenderer
implements IValueTypeWorldRenderer {
    @Override
    public void renderValue(BlockEntityRendererProvider.Context context, IPartContainer partContainer, Direction direction, IPartType partType, IValue value, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLight, int combinedOverlay, float alpha) {
        ItemStack itemStackOptional = ((ValueObjectTypeItemStack.ValueItemStack)value).getRawValue();
        if (!itemStackOptional.isEmpty()) {
            ItemValueTypeWorldRenderer.renderItemStack(matrixStack, renderTypeBuffer, combinedLight, combinedOverlay, itemStackOptional, alpha);
            matrixStack.pushPose();
            matrixStack.translate(7.0f, 8.5f, 0.3f);
            String stackSize = String.valueOf(itemStackOptional.getCount());
            float scale = 1.0f / ((float)stackSize.length() + 1.0f);
            matrixStack.scale(scale, scale, 1.0f);
            context.getFont().drawInBatch(stackSize, 0.0f, 0.0f, IModHelpers.get().getBaseHelpers().RGBAToInt(200, 200, 200, (int)(alpha * 255.0f)), false, matrixStack.last().pose(), renderTypeBuffer, Font.DisplayMode.NORMAL, 0, combinedLight);
            matrixStack.popPose();
        }
    }

    public static void renderItemStack(PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLight, int combinedOverlay, ItemStack itemStack, float alpha) {
        matrixStack.pushPose();
        matrixStack.translate(6.2, 6.2, (double)0.1f);
        matrixStack.scale(16.0f, -16.0f, 16.0f);
        matrixStack.scale(0.74f, 0.74f, 0.01f);
        ItemStackRenderState renderState = new ItemStackRenderState();
        Minecraft.getInstance().getItemModelResolver().updateForTopItem(renderState, itemStack, ItemDisplayContext.GUI, null, null, 0);
        renderState.render(matrixStack, renderTypeBuffer, combinedLight, combinedOverlay);
        matrixStack.popPose();
    }
}

