/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxyFactoryTypeRegistry;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyFactories;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNBTFactorySimple;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueTypeListProxyOperatorMapped
extends ValueTypeListProxyBase<IValueType<IValue>, IValue> {
    private final IOperator operator;
    private final IValueTypeListProxy listProxy;

    public ValueTypeListProxyOperatorMapped(IOperator operator, IValueTypeListProxy listProxy) {
        super(ValueTypeListProxyFactories.MAPPED.getName(), operator.getInputTypes().length == 1 ? operator.getOutputType() : ValueTypes.OPERATOR);
        this.operator = operator;
        this.listProxy = listProxy;
    }

    @Override
    public int getLength() throws EvaluationException {
        return this.listProxy.getLength();
    }

    @Override
    public IValue get(int index) throws EvaluationException {
        Object value = this.listProxy.get(index);
        return ValueHelpers.evaluateOperator(this.operator, new IValue[]{value});
    }

    public static class Factory
    extends ValueTypeListProxyNBTFactorySimple<IValueType<IValue>, IValue, ValueTypeListProxyOperatorMapped> {
        @Override
        public ResourceLocation getName() {
            return ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"mapped");
        }

        @Override
        protected void serializeNbt(ValueOutput valueOutput, ValueTypeListProxyOperatorMapped value) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
            Operators.REGISTRY.serialize(valueOutput.child("operator"), value.operator);
            ValueTypeListProxyFactories.REGISTRY.serialize(valueOutput.child("sublist"), value.listProxy);
        }

        @Override
        protected ValueTypeListProxyOperatorMapped deserializeNbt(ValueInput valueInput) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException, EvaluationException {
            IOperator operator = Operators.REGISTRY.deserialize((ValueInput)valueInput.child("operator").orElseThrow());
            Object list = ValueTypeListProxyFactories.REGISTRY.deserialize((ValueInput)valueInput.child("sublist").orElseThrow());
            return new ValueTypeListProxyOperatorMapped(operator, (IValueTypeListProxy)list);
        }
    }
}

