/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import com.google.common.collect.Sets;
import java.util.HashSet;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeLong;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NbtHelpers {
    private static final Logger log = LoggerFactory.getLogger(NbtHelpers.class);

    public static boolean nbtMatchesSubset(CompoundTag a, CompoundTag b, boolean recursive) {
        for (String key : a.keySet()) {
            Tag valueA = a.get(key);
            if (recursive && (valueA instanceof CompoundTag || valueA instanceof ListTag)) {
                CompoundTag tagB;
                CompoundTag tagA;
                Tag valueB = b.get(key);
                if (valueA instanceof CompoundTag) {
                    if (!(valueB instanceof CompoundTag)) {
                        return false;
                    }
                    tagA = (CompoundTag)valueA;
                    tagB = (CompoundTag)valueB;
                    if (NbtHelpers.nbtMatchesSubset(tagA, tagB, recursive)) continue;
                    return false;
                }
                if (!(valueA instanceof ListTag)) continue;
                if (!(valueB instanceof ListTag)) {
                    return false;
                }
                tagA = (ListTag)valueA;
                tagB = (ListTag)valueB;
                for (int i = 0; i < tagA.size(); ++i) {
                    CompoundTag subTagA = (CompoundTag)tagA.getCompound(i).orElseThrow();
                    boolean foundA = false;
                    for (int j = 0; j < tagB.size(); ++j) {
                        CompoundTag subTagB = (CompoundTag)tagB.getCompound(j).orElseThrow();
                        if (!NbtHelpers.nbtMatchesSubset(subTagA, subTagB, recursive)) continue;
                        foundA = true;
                        break;
                    }
                    if (foundA) continue;
                    return false;
                }
                continue;
            }
            if (valueA.equals((Object)b.get(key))) continue;
            return false;
        }
        return true;
    }

    public static CompoundTag union(CompoundTag ... tags) {
        CompoundTag tag = new CompoundTag();
        for (CompoundTag inputTag : tags) {
            tag.merge(inputTag);
        }
        return tag;
    }

    public static CompoundTag intersection(CompoundTag ... tags) {
        if (tags.length == 0) {
            return new CompoundTag();
        }
        System.out.println(tags[0]);
        System.out.println(tags[1].toString());
        CompoundTag tag = null;
        for (CompoundTag inputTag : tags) {
            if (tag == null) {
                tag = inputTag.copy();
                continue;
            }
            HashSet keys = Sets.newHashSet((Iterable)tag.keySet());
            for (String key : keys) {
                byte type = tag.get(key).getId();
                if (!inputTag.contains(key)) {
                    tag.remove(key);
                    continue;
                }
                if (type != 10) continue;
                tag.put(key, (Tag)NbtHelpers.intersection((CompoundTag)tag.getCompound(key).orElseThrow(), (CompoundTag)inputTag.getCompound(key).orElseThrow()));
            }
        }
        return tag;
    }

    public static CompoundTag minus(CompoundTag a, CompoundTag b) {
        CompoundTag tag = a.copy();
        for (String key : b.keySet()) {
            byte type = b.get(key).getId();
            if (!tag.contains(key)) continue;
            if (type == 10) {
                CompoundTag difference = NbtHelpers.minus((CompoundTag)tag.getCompound(key).orElseThrow(), (CompoundTag)b.getCompound(key).orElseThrow());
                if (difference.isEmpty()) {
                    tag.remove(key);
                    continue;
                }
                tag.put(key, (Tag)difference);
                continue;
            }
            tag.remove(key);
        }
        return tag;
    }

    public static ListTag getListNbtTag(ValueTypeList.ValueList<?, ?> value, Component operatorName) {
        ListTag list = new ListTag();
        for (IValue valueNbt : value.getRawValue()) {
            if (value.getRawValue().getValueType() != ValueTypes.NBT && (value.getRawValue().getValueType() != ValueTypes.CATEGORY_ANY || valueNbt.getType() != ValueTypes.NBT)) {
                MutableComponent error = Component.translatable((String)"operator.integrateddynamics.error.wrong_type", (Object[])new Object[]{operatorName, Component.translatable((String)value.getRawValue().getValueType().getTranslationKey()), 1, Component.translatable((String)ValueTypes.NBT.getTranslationKey())});
                Helpers.sneakyThrow(new EvaluationException(error));
            }
            ((ValueTypeNbt.ValueNbt)valueNbt).getRawValue().ifPresent(arg_0 -> list.add(arg_0));
        }
        return list;
    }

    public static ByteArrayTag getListNbtByte(ValueTypeList.ValueList<?, ?> value, Component operatorName) {
        byte[] array = null;
        try {
            array = new byte[value.getRawValue().getLength()];
        }
        catch (EvaluationException error) {
            Helpers.sneakyThrow(error);
        }
        int index = 0;
        for (IValue valueNbt : value.getRawValue()) {
            if (valueNbt.getType() != ValueTypes.INTEGER) {
                MutableComponent error = Component.translatable((String)"operator.integrateddynamics.error.wrong_type", (Object[])new Object[]{operatorName, Component.translatable((String)valueNbt.getType().getTranslationKey()), 1, Component.translatable((String)ValueTypes.INTEGER.getTranslationKey())});
                Helpers.sneakyThrow(new EvaluationException(error));
            }
            array[index++] = (byte)((ValueTypeInteger.ValueInteger)valueNbt).getRawValue();
        }
        return new ByteArrayTag(array);
    }

    public static IntArrayTag getListNbtInt(ValueTypeList.ValueList<?, ?> value, Component operatorName) {
        int[] array = null;
        try {
            array = new int[value.getRawValue().getLength()];
        }
        catch (EvaluationException error) {
            Helpers.sneakyThrow(error);
        }
        int index = 0;
        for (IValue valueNbt : value.getRawValue()) {
            if (valueNbt.getType() != ValueTypes.INTEGER) {
                MutableComponent error = Component.translatable((String)"operator.integrateddynamics.error.wrong_type", (Object[])new Object[]{operatorName, Component.translatable((String)valueNbt.getType().getTranslationKey()), 1, Component.translatable((String)ValueTypes.INTEGER.getTranslationKey())});
                Helpers.sneakyThrow(new EvaluationException(error));
            }
            array[index++] = ((ValueTypeInteger.ValueInteger)valueNbt).getRawValue();
        }
        return new IntArrayTag(array);
    }

    public static LongArrayTag getListNbtLong(ValueTypeList.ValueList<?, ?> value, Component operatorName) {
        long[] array = null;
        try {
            array = new long[value.getRawValue().getLength()];
        }
        catch (EvaluationException error) {
            Helpers.sneakyThrow(error);
        }
        int index = 0;
        for (IValue valueNbt : value.getRawValue()) {
            if (valueNbt.getType() != ValueTypes.LONG) {
                MutableComponent error = Component.translatable((String)"operator.integrateddynamics.error.wrong_type", (Object[])new Object[]{operatorName, Component.translatable((String)valueNbt.getType().getTranslationKey()), 1, Component.translatable((String)ValueTypes.LONG.getTranslationKey())});
                Helpers.sneakyThrow(new EvaluationException(error));
            }
            array[index++] = ((ValueTypeLong.ValueLong)valueNbt).getRawValue();
        }
        return new LongArrayTag(array);
    }
}

