/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest.integration;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.TestData;
import net.minecraft.gametest.framework.TestEnvironmentDefinition;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Rotation;
import org.cyclops.integrateddynamics.command.CommandTest;
import org.cyclops.integrateddynamics.core.test.IntegrationTest;
import org.cyclops.integrateddynamics.gametest.integration.IntegrationMethodGameTestInstance;

public class GameTester {
    public static GameTestHelper GAME_TEST_HELPER;

    public static void registerCommonTests(String modId, BiConsumer<ResourceLocation, GameTestInstance> registrar, Registry<TestEnvironmentDefinition> testEnvironmentRegistry) {
        for (IntegrationMethodGameTestInstance testInstance : GameTester.integrationTests(modId, testEnvironmentRegistry)) {
            registrar.accept(testInstance.getId(), testInstance);
        }
    }

    public static Collection<IntegrationMethodGameTestInstance> integrationTests(String modId, Registry<TestEnvironmentDefinition> testEnvironmentRegistry) {
        ArrayList testsList = Lists.newArrayList();
        for (String className : CommandTest.CLASSES) {
            try {
                Class<?> clazz = Class.forName(className);
                LinkedList tests = Lists.newLinkedList();
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(IntegrationTest.class)) continue;
                    tests.add(method);
                }
                for (Method method : tests) {
                    Holder.Reference environment = testEnvironmentRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.TEST_ENVIRONMENT, (ResourceLocation)ResourceLocation.parse((String)"default")));
                    testsList.add(new IntegrationMethodGameTestInstance((TestData<Holder<TestEnvironmentDefinition>>)new TestData((Object)environment, ResourceLocation.parse((String)"integrateddynamics:test"), 1, 1, true, Rotation.NONE, false, 1, 1, false), modId, clazz.getName(), method.getName()));
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return testsList;
    }
}

