/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest.integration;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.TestData;
import net.minecraft.gametest.framework.TestEnvironmentDefinition;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.integrateddynamics.core.test.IntegrationBefore;
import org.cyclops.integrateddynamics.core.test.IntegrationTest;
import org.cyclops.integrateddynamics.gametest.integration.GameTester;

public class IntegrationMethodGameTestInstance
extends GameTestInstance {
    public static final MapCodec<? extends GameTestInstance> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TestData.CODEC.forGetter(rec$ -> ((IntegrationMethodGameTestInstance)((Object)((Object)((Object)rec$)))).info()), (App)Codec.STRING.fieldOf("modId").forGetter(IntegrationMethodGameTestInstance::getModId), (App)Codec.STRING.fieldOf("class").forGetter(IntegrationMethodGameTestInstance::getClassName), (App)Codec.STRING.fieldOf("method").forGetter(IntegrationMethodGameTestInstance::getMethodName)).apply((Applicative)instance, IntegrationMethodGameTestInstance::new));
    private final String modId;
    private final String className;
    private final String methodName;

    public IntegrationMethodGameTestInstance(TestData<Holder<TestEnvironmentDefinition>> info, String modId, String className, String methodName) {
        super(info);
        this.modId = modId;
        this.className = className;
        this.methodName = methodName;
    }

    public String getModId() {
        return this.modId;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void run(GameTestHelper gameTestHelper) {
        try {
            Class<?> clazz = Class.forName(this.className);
            Object instance = clazz.newInstance();
            LinkedList befores = Lists.newLinkedList();
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(IntegrationBefore.class)) continue;
                befores.add(method);
            }
            Method method = clazz.getMethod(this.methodName, new Class[0]);
            gameTestHelper.succeedIf(() -> {
                GameTester.GAME_TEST_HELPER = gameTestHelper;
                try {
                    for (Method before : befores) {
                        before.invoke(instance, new Object[0]);
                    }
                    method.invoke(instance, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    Class<?> excepted = method.getAnnotation(IntegrationTest.class).expected();
                    if (!excepted.isInstance(e.getTargetException())) {
                        if (e.getTargetException() instanceof IllegalStateException || e.getTargetException() instanceof AssertionError) {
                            e.getTargetException().printStackTrace();
                            throw new GameTestAssertException((Component)Component.literal((String)("Test " + this.getId().toString() + " failed!")), (int)gameTestHelper.getTick());
                        }
                        e.getTargetException().printStackTrace();
                        throw new GameTestAssertException((Component)Component.literal((String)String.format("Expected at %s exception %s, but found:", this.getId().toString(), e)), (int)gameTestHelper.getTick());
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    throw new GameTestAssertException((Component)Component.literal((String)e.getMessage()), (int)gameTestHelper.getTick());
                }
            });
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            e.printStackTrace();
            throw new GameTestAssertException((Component)Component.literal((String)e.getMessage()), (int)gameTestHelper.getTick());
        }
    }

    public MapCodec<? extends GameTestInstance> codec() {
        return CODEC;
    }

    protected MutableComponent typeDescription() {
        return Component.literal((String)("Method-based test instance for " + this.getClassName() + "." + this.getMethodName()));
    }

    public ResourceLocation getId() {
        return ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)(this.className.replaceAll("org.cyclops\\.[^.]*\\.[^.]*\\.", "") + "." + this.methodName).toLowerCase(Locale.ROOT).replace('.', '_'));
    }
}

