/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.infobook.pageelement;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.ARGB;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendixClient;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectWrite;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.infobook.pageelement.AspectAppendix;

public class AspectAppendixClient
extends SectionAppendixClient<AspectAppendix> {
    private static final int SLOT_SIZE = 16;

    protected AspectAppendixClient(AspectAppendix sectionAppendix) {
        super((SectionAppendix)sectionAppendix);
    }

    protected void drawElement(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, int width, int height, int page, int mx, int my) {
        AspectAppendix section = (AspectAppendix)this.getSectionAppendix();
        IAspect<?, ?> aspect = section.getAspect();
        int yOffset = 5;
        gui.drawOuterBorder(guiGraphics, x - 1, y - 1 - yOffset, section.getWidth() + 2, section.getHeight() + 2, 0.5f, 0.5f, 0.5f, 0.4f);
        gui.drawTextBanner(guiGraphics, x + width / 2, y - 2 - yOffset);
        gui.drawScaledCenteredString(guiGraphics, IModHelpers.get().getL10NHelpers().localize("aspect.integrateddynamics.name", new Object[0]), x, y - 2 - yOffset, width, 0.9f, gui.getBannerWidth() - 6, IModHelpers.get().getBaseHelpers().RGBAToInt(30, 20, 120, 255));
        guiGraphics.renderItem(section.getItemStack(), x, y);
        String aspectName = IModHelpers.get().getL10NHelpers().localize(aspect.getTranslationKey(), new Object[0]);
        String valueTypeName = IModHelpers.get().getL10NHelpers().localize(aspect.getValueType().getTranslationKey(), new Object[0]);
        gui.drawScaledCenteredString(guiGraphics, IModHelpers.get().getL10NHelpers().localize(aspectName, new Object[0]), x + 10, y + 8, width, 1.0f, gui.getBannerWidth() - 10, ARGB.opaque((int)0));
        String valueString = IModHelpers.get().getL10NHelpers().localize(String.valueOf(aspect.getValueType().getDisplayColorFormat()) + valueTypeName, new Object[0]);
        guiGraphics.drawString(gui.getFont(), IModHelpers.get().getL10NHelpers().localize(aspect instanceof IAspectWrite ? "gui.integrateddynamics.input" : "gui.integrateddynamics.output", new Object[]{valueString}), x, y + 16, ARGB.opaque((int)0), false);
        if (aspect.hasProperties()) {
            int offsetY = 26;
            guiGraphics.drawString(gui.getFont(), String.valueOf(ChatFormatting.DARK_GRAY) + IModHelpers.get().getL10NHelpers().localize("gui.integrateddynamics.part.properties", new Object[0]), x, y + offsetY, ARGB.opaque((int)0), false);
            for (IAspectPropertyTypeInstance property : aspect.getPropertyTypes()) {
                guiGraphics.drawString(gui.getFont(), String.valueOf(ChatFormatting.DARK_GRAY) + IModHelpers.get().getL10NHelpers().localize(property.getTranslationKey(), new Object[0]), x + 10, y + (offsetY += 10), ARGB.opaque((int)0), false);
            }
        }
    }

    protected void postDrawElement(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, int width, int height, int page, int mx, int my) {
        if (mx >= x && my >= y && mx <= x + 16 && my <= y + 16) {
            ArrayList lines = Lists.newArrayList();
            ((AspectAppendix)this.getSectionAppendix()).getAspect().loadTooltip(lines::add, true);
            guiGraphics.setComponentTooltipForNextFrame(gui.getFont(), (List)lines, mx, my);
        }
    }
}

