/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.part;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfigCommon;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.InvalidValueTypeException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.block.BlockInvisibleLight;
import org.cyclops.integrateddynamics.block.BlockInvisibleLightConfig;
import org.cyclops.integrateddynamics.core.block.IgnoredBlockStatus;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeLightLevels;
import org.cyclops.integrateddynamics.core.part.panel.PartTypePanelVariableDriven;

public class PartTypePanelLightDynamic
extends PartTypePanelVariableDriven<PartTypePanelLightDynamic, State> {
    public PartTypePanelLightDynamic(String name) {
        super(name);
    }

    @Override
    public boolean supportsOffsets() {
        return false;
    }

    @Override
    protected Block createBlock(BlockConfigCommon<?> blockConfig, BlockBehaviour.Properties properties) {
        return new IgnoredBlockStatus(properties);
    }

    @Override
    public State constructDefaultState() {
        return new State();
    }

    @Override
    public int getConsumptionRate(State state) {
        return GeneralConfig.panelLightDynamicBaseConsumption;
    }

    @Override
    protected IgnoredBlockStatus.Status getStatus(PartTypePanelVariableDriven.State state) {
        IgnoredBlockStatus.Status status = super.getStatus(state);
        if (status == IgnoredBlockStatus.Status.ACTIVE && state.getDisplayValue() != null && this.getLightLevel((State)state, state.getDisplayValue()) == 0) {
            return IgnoredBlockStatus.Status.INACTIVE;
        }
        return status;
    }

    @Override
    protected void onValueChanged(INetwork network, IPartNetwork partNetwork, PartTarget target, State state, IValue lastValue, IValue newValue) {
        super.onValueChanged(network, partNetwork, target, state, lastValue, newValue);
        int lightLevel = 0;
        if (newValue != null) {
            lightLevel = this.getLightLevel(state, newValue);
        }
        PartTypePanelLightDynamic.setLightLevel(target, lightLevel);
        state.sendUpdate();
    }

    protected int getLightLevel(State state, IValue value) {
        try {
            return ValueTypeLightLevels.REGISTRY.getLightLevel(value);
        }
        catch (InvalidValueTypeException e) {
            state.addGlobalError((Component)Component.translatable((String)"parttype.integrateddynamics.data_driven_panel.error.invalid_type", (Object[])new Object[]{Component.translatable((String)value.getType().getTranslationKey())}));
            return 0;
        }
    }

    @Override
    public void onNetworkRemoval(INetwork network, IPartNetwork partNetwork, PartTarget target, State state) {
        super.onNetworkRemoval(network, partNetwork, target, state);
        PartTypePanelLightDynamic.setLightLevel(target, 0);
    }

    @Override
    public void onPostRemoved(INetwork network, IPartNetwork partNetwork, PartTarget target, State state) {
        super.onPostRemoved(network, partNetwork, target, state);
        PartTypePanelLightDynamic.setLightLevel(target, 0);
    }

    @Override
    public void onBlockNeighborChange(INetwork network, IPartNetwork partNetwork, PartTarget target, State state, BlockGetter world) {
        super.onBlockNeighborChange(network, partNetwork, target, state, world);
        PartTypePanelLightDynamic.setLightLevel(target, state.getDisplayValue() == null ? 0 : this.getLightLevel(state, state.getDisplayValue()));
    }

    @Override
    public void postUpdate(INetwork network, IPartNetwork partNetwork, PartTarget target, State state, boolean updated) {
        boolean wasEnabled = this.isEnabled(state);
        super.postUpdate(network, partNetwork, target, state, updated);
        boolean isEnabled = this.isEnabled(state);
        if (wasEnabled != isEnabled) {
            PartTypePanelLightDynamic.setLightLevel(target, isEnabled ? this.getLightLevel(state, state.getDisplayValue()) : 0);
        }
    }

    public static void setLightLevel(PartTarget target, int lightLevel) {
        if (BlockInvisibleLightConfig.invisibleLightBlock) {
            BlockPos pos;
            Level world = target.getTarget().getPos().getLevel(true);
            if (world.isEmptyBlock(pos = target.getTarget().getPos().getBlockPos()) || world.getBlockState(pos).getBlock() == RegistryEntries.BLOCK_INVISIBLE_LIGHT.get()) {
                if (lightLevel > 0) {
                    world.setBlockAndUpdate(pos, (BlockState)((Block)RegistryEntries.BLOCK_INVISIBLE_LIGHT.get()).defaultBlockState().setValue((Property)BlockInvisibleLight.LIGHT, (Comparable)Integer.valueOf(lightLevel)));
                } else {
                    world.setBlock(pos, Blocks.AIR.defaultBlockState(), IModHelpers.get().getMinecraftHelpers().getBlockNotifyClient());
                }
            }
        } else {
            IModHelpersNeoForge.get().getCapabilityHelpers().getCapability(target.getCenter().getPos(), (Object)target.getCenter().getSide(), Capabilities.DynamicLight.BLOCK).ifPresent(dynamicLight -> dynamicLight.setLightLevel(lightLevel));
        }
    }

    public static class State
    extends PartTypePanelVariableDriven.State<PartTypePanelLightDynamic, State> {
    }
}

