/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jade;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.integrateddynamics.blockentity.BlockEntityMechanicalDryingBasin;
import org.cyclops.integrateddynamicscompat.modcompat.jade.JadeIntegratedDynamicsConfig;
import org.cyclops.integrateddynamicscompat.modcompat.jade.SqueezerDataProviderServer;
import snownee.jade.api.BlockAccessor;

public class MechanicalDryingBasinDataProviderServer
extends SqueezerDataProviderServer {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"integrateddynamicscompat", (String)"mechanical_drying_basin");

    @Override
    public void appendServerData(CompoundTag tag, BlockAccessor accessor) {
        BlockEntityMechanicalDryingBasin tile = (BlockEntityMechanicalDryingBasin)accessor.getBlockEntity();
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(Component.translatable((String)"gui.integrateddynamics.waila.energy", (Object[])new Object[]{tile.getEnergyStored(), tile.getMaxEnergyStored()}));
        if (!tile.getInventory().getItem(0).isEmpty()) {
            tooltip.add(Component.translatable((String)"gui.integrateddynamics.waila.item.in", (Object[])new Object[]{tile.getInventory().getItem(0).getDisplayName()}));
        }
        for (int i = 1; i < tile.getInventory().getContainerSize(); ++i) {
            if (tile.getInventory().getItem(i).isEmpty()) continue;
            tooltip.add(Component.translatable((String)"gui.integrateddynamics.waila.item.out", (Object[])new Object[]{tile.getInventory().getItem(i).getDisplayName()}));
        }
        if (!tile.getTankInput().isEmpty()) {
            tooltip.add(Component.translatable((String)"gui.integrateddynamics.waila.fluid.in", (Object[])new Object[]{tile.getTankInput().getFluid().getHoverName(), tile.getTankInput().getFluidAmount()}));
        }
        if (!tile.getTankOutput().isEmpty()) {
            tooltip.add(Component.translatable((String)"gui.integrateddynamics.waila.fluid.out", (Object[])new Object[]{tile.getTankOutput().getFluid().getHoverName(), tile.getTankOutput().getFluidAmount()}));
        }
        if (tile.getProgress() > 0) {
            tooltip.add(Component.translatable((String)"gui.integrateddynamics.waila.progress", (Object[])new Object[]{tile.getProgress() * 100 / tile.getMaxProgress()}));
        }
        JadeIntegratedDynamicsConfig.putTooltip(tag, tooltip);
    }

    @Override
    public ResourceLocation getUid() {
        return ID;
    }
}

