/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jei;

import com.google.common.collect.Lists;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeHolderType;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLogicProgrammer;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLogicProgrammerPortable;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenMechanicalDryingBasin;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenMechanicalSqueezer;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenOnTheDynamicsOfIntegration;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammer;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerPortable;
import org.cyclops.integrateddynamics.inventory.container.ContainerMechanicalDryingBasin;
import org.cyclops.integrateddynamics.inventory.container.ContainerMechanicalSqueezer;
import org.cyclops.integrateddynamicscompat.modcompat.jei.dryingbasin.DryingBasinRecipeCategory;
import org.cyclops.integrateddynamicscompat.modcompat.jei.logicprogrammer.LogicProgrammerGhostIngredientHandler;
import org.cyclops.integrateddynamicscompat.modcompat.jei.logicprogrammer.LogicProgrammerTransferHandler;
import org.cyclops.integrateddynamicscompat.modcompat.jei.mechanicaldryingbasin.MechanicalDryingBasinRecipeCategory;
import org.cyclops.integrateddynamicscompat.modcompat.jei.mechanicalsqueezer.MechanicalSqueezerRecipeCategory;
import org.cyclops.integrateddynamicscompat.modcompat.jei.squeezer.SqueezerRecipeCategory;

@JeiPlugin
public class JEIIntegratedDynamicsConfig
implements IModPlugin {
    public static IJeiRuntime jeiRuntime;

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new DryingBasinRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SqueezerRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new MechanicalDryingBasinRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new MechanicalSqueezerRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registry) {
        this.addRecipes(registry, DryingBasinRecipeCategory.TYPE, (RecipeType)RegistryEntries.RECIPETYPE_DRYING_BASIN.get());
        this.addRecipes(registry, SqueezerRecipeCategory.TYPE, (RecipeType)RegistryEntries.RECIPETYPE_SQUEEZER.get());
        this.addRecipes(registry, MechanicalDryingBasinRecipeCategory.TYPE, (RecipeType)RegistryEntries.RECIPETYPE_MECHANICAL_DRYING_BASIN.get());
        this.addRecipes(registry, MechanicalSqueezerRecipeCategory.TYPE, (RecipeType)RegistryEntries.RECIPETYPE_MECHANICAL_SQUEEZER.get());
    }

    protected <I extends RecipeInput, T extends Recipe<I>> void addRecipes(IRecipeRegistration registry, IRecipeHolderType<T> recipeTypeJei, RecipeType<T> recipeType) {
        registry.addRecipes(recipeTypeJei, (List)Lists.newArrayList((Iterable)IModHelpers.get().getMinecraftClientHelpers().getRecipes().byType(recipeType)));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addCraftingStation(DryingBasinRecipeCategory.TYPE, new ItemStack[]{new ItemStack((ItemLike)RegistryEntries.BLOCK_DRYING_BASIN.get())});
        registry.addCraftingStation(SqueezerRecipeCategory.TYPE, new ItemStack[]{new ItemStack((ItemLike)RegistryEntries.BLOCK_SQUEEZER.get())});
        registry.addCraftingStation(MechanicalDryingBasinRecipeCategory.TYPE, new ItemStack[]{new ItemStack((ItemLike)RegistryEntries.BLOCK_MECHANICAL_DRYING_BASIN.get())});
        registry.addCraftingStation(MechanicalSqueezerRecipeCategory.TYPE, new ItemStack[]{new ItemStack((ItemLike)RegistryEntries.BLOCK_MECHANICAL_SQUEEZER.get())});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registry) {
        registry.addRecipeTransferHandler(ContainerMechanicalDryingBasin.class, null, MechanicalDryingBasinRecipeCategory.TYPE, 0, 1, 5, 36);
        registry.addRecipeTransferHandler(ContainerMechanicalSqueezer.class, null, MechanicalSqueezerRecipeCategory.TYPE, 0, 1, 5, 36);
        registry.addUniversalRecipeTransferHandler(new LogicProgrammerTransferHandler<ContainerLogicProgrammer>(ContainerLogicProgrammer.class));
        registry.addUniversalRecipeTransferHandler(new LogicProgrammerTransferHandler<ContainerLogicProgrammerPortable>(ContainerLogicProgrammerPortable.class));
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        registry.addRecipeClickArea(ContainerScreenMechanicalDryingBasin.class, 84, 31, 10, 27, new IRecipeType[]{MechanicalDryingBasinRecipeCategory.TYPE});
        registry.addRecipeClickArea(ContainerScreenMechanicalSqueezer.class, 73, 36, 12, 18, new IRecipeType[]{MechanicalSqueezerRecipeCategory.TYPE});
        registry.addGuiScreenHandler(ContainerScreenOnTheDynamicsOfIntegration.class, screen -> null);
        registry.addGhostIngredientHandler(ContainerScreenLogicProgrammer.class, new LogicProgrammerGhostIngredientHandler());
        registry.addGhostIngredientHandler(ContainerScreenLogicProgrammerPortable.class, new LogicProgrammerGhostIngredientHandler());
    }

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"integrateddynamicscompat", (String)"main");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JEIIntegratedDynamicsConfig.jeiRuntime = jeiRuntime;
    }
}

