/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.cyclops.cyclopscore.config.ConfigurablePropertyCommon;
import org.cyclops.cyclopscore.config.extendedconfig.BlockClientConfig;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfigCommon;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.block.BlockEnergyBattery;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryConfigClient;
import org.cyclops.integrateddynamics.capability.energystorage.IEnergyStorageCapacity;
import org.cyclops.integrateddynamics.core.item.ItemBlockEnergyContainer;
import org.cyclops.integrateddynamics.core.item.ItemBlockEnergyContainerAutoSupply;
import org.jetbrains.annotations.Nullable;

public class BlockEnergyBatteryConfig
extends BlockConfigCommon<IntegratedDynamics> {
    @ConfigurablePropertyCommon(category="machine", comment="The default capacity of an energy battery.", minimalValue=0)
    public static int capacity = 1000000;
    @ConfigurablePropertyCommon(category="machine", comment="The 1/X fraction of the battery capacity that is allowed to be transfered per tick.", isCommandable=true, minimalValue=0)
    public static int energyRateCapacityFraction = 2000;
    @ConfigurablePropertyCommon(category="machine", comment="The minimum energy transfer rate per tick.", isCommandable=true, minimalValue=0)
    public static int minEnergyRate = 2000;
    @ConfigurablePropertyCommon(category="machine", comment="The maximum capacity shown in creative tabs. (Make sure that you do not cross the max int size)")
    public static int maxCreativeTabCapacity = 655360000;
    @ConfigurablePropertyCommon(category="machine", comment="The maximum capacity visible in the creative tabs. (Make sure that you do not cross the max int size)")
    public static int maxCreativeCapacity = 40960000;

    public BlockEnergyBatteryConfig() {
        super((IModBase)IntegratedDynamics._instance, "energy_battery", (eConfig, properties) -> new BlockEnergyBattery(properties.sound(SoundType.METAL).strength(2.0f, 5.0f)), (eConfig, block) -> new ItemBlockEnergyContainerAutoSupply((Block)block, eConfig.createDefaultItemProperties()));
        IntegratedDynamics._instance.getModEventBus().addListener(this::registerCapability);
        IntegratedDynamics._instance.getModEventBus().addListener(this::fillCreativeTab);
    }

    protected void registerCapability(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, context) -> ((ItemBlockEnergyContainer)this.getItemInstance()).createCapability((ItemStack)stack), new ItemLike[]{(ItemLike)this.getInstance()});
    }

    protected void fillCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == IntegratedDynamics._instance.getDefaultCreativeTab()) {
            for (ItemStack itemStack : this.dynamicCreativeTabEntries()) {
                event.accept(itemStack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
    }

    public Collection<ItemStack> getDefaultCreativeTabEntries() {
        return Collections.emptyList();
    }

    protected Collection<ItemStack> dynamicCreativeTabEntries() {
        int lastCapacity;
        int capacityOriginal;
        ArrayList itemStacks = Lists.newArrayList();
        ItemStack itemStack = new ItemStack((ItemLike)this.getInstance());
        int capacity = capacityOriginal = BlockEnergyBatteryConfig.capacity;
        do {
            ItemStack currentStack = itemStack.copy();
            IEnergyStorageCapacity energyStorage = ((ItemBlockEnergyContainer)currentStack.getItem()).getEnergyBattery(currentStack).orElse(null);
            energyStorage.setCapacity(capacity);
            itemStacks.add(currentStack.copy());
            BlockEnergyBattery cfr_ignored_0 = (BlockEnergyBattery)((Object)this.getInstance());
            BlockEnergyBattery.fill(energyStorage);
            itemStacks.add(currentStack.copy());
            lastCapacity = capacity;
        } while ((capacity <<= 2) < Math.min(maxCreativeCapacity, maxCreativeTabCapacity) && capacity > lastCapacity);
        return itemStacks;
    }

    @Nullable
    public BlockClientConfig<IntegratedDynamics> constructBlockClientConfig() {
        return new BlockEnergyBatteryConfigClient(this);
    }
}

