/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.capability.dynamicredstone;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.integrateddynamics.api.block.IDynamicRedstone;

public class DynamicRedstoneHolderGlobal {
    private static final DynamicRedstoneHolderGlobal _INSTANCE = new DynamicRedstoneHolderGlobal();
    private Map<DimPos, EnumFacingMap<Integer>> redstoneLevels = Maps.newHashMap();
    private Map<DimPos, EnumFacingMap<Boolean>> redstoneStrong = Maps.newHashMap();

    private DynamicRedstoneHolderGlobal() {
    }

    public static DynamicRedstoneHolderGlobal getInstance() {
        return _INSTANCE;
    }

    public boolean hasLevels() {
        return !this.redstoneLevels.isEmpty();
    }

    public IDynamicRedstone getDynamicRedstone(DimPos dimPos, Direction side) {
        return new DynamicRedstoneVirtual(this, dimPos, side);
    }

    public static class DynamicRedstoneVirtual
    implements IDynamicRedstone {
        private final DynamicRedstoneHolderGlobal holder;
        private final DimPos dimPos;
        private final Direction side;

        public DynamicRedstoneVirtual(DynamicRedstoneHolderGlobal holder, DimPos dimPos, Direction side) {
            this.holder = holder;
            this.dimPos = dimPos;
            this.side = side;
        }

        @Override
        public void setRedstoneLevel(int level, boolean direct) {
            EnumFacingMap redstoneStrongs;
            EnumFacingMap redstoneLevels = this.holder.redstoneLevels.get(this.dimPos);
            if (redstoneLevels == null) {
                redstoneLevels = EnumFacingMap.newMap();
                this.holder.redstoneLevels.put(this.dimPos, (EnumFacingMap<Integer>)redstoneLevels);
            }
            if ((redstoneStrongs = this.holder.redstoneStrong.get(this.dimPos)) == null) {
                redstoneStrongs = EnumFacingMap.newMap();
                this.holder.redstoneStrong.put(this.dimPos, (EnumFacingMap<Boolean>)redstoneStrongs);
            }
            boolean sendUpdate = false;
            boolean sendUpdateStrong = false;
            if (redstoneLevels.containsKey((Object)this.side)) {
                if ((Integer)redstoneLevels.get((Object)this.side) != level) {
                    sendUpdate = true;
                    if (level < 0) {
                        redstoneLevels.remove((Object)this.side);
                    } else {
                        redstoneLevels.put((Enum)this.side, (Object)level);
                    }
                }
            } else {
                sendUpdate = true;
                if (level < 0) {
                    redstoneLevels.remove((Object)this.side);
                } else {
                    redstoneLevels.put((Enum)this.side, (Object)level);
                }
            }
            if (redstoneStrongs.containsKey((Object)this.side)) {
                if ((Boolean)redstoneStrongs.get((Object)this.side) != direct) {
                    sendUpdateStrong = true;
                    sendUpdate = true;
                    if (level < 0) {
                        redstoneStrongs.remove((Object)this.side);
                    } else {
                        redstoneStrongs.put((Enum)this.side, (Object)direct);
                    }
                }
            } else {
                sendUpdateStrong = true;
                sendUpdate = true;
                if (level < 0) {
                    redstoneStrongs.remove((Object)this.side);
                } else {
                    redstoneStrongs.put((Enum)this.side, (Object)direct);
                }
            }
            if (redstoneLevels.isEmpty()) {
                this.holder.redstoneLevels.remove(this.dimPos);
            }
            if (redstoneStrongs.isEmpty()) {
                this.holder.redstoneStrong.remove(this.dimPos);
            }
            if (sendUpdate) {
                this.updateRedstoneInfo(direct || sendUpdateStrong);
            }
        }

        public void updateRedstoneInfo(boolean strongPower) {
            BlockPos pos;
            Level level = this.dimPos.getLevel(false);
            if (level != null && level.isLoaded((pos = this.dimPos.getBlockPos()).relative(this.side.getOpposite()))) {
                BlockState blockState = level.getBlockState(pos);
                Orientation orientation = ExperimentalRedstoneUtils.initialOrientation((Level)level, (Direction)this.side.getOpposite(), null);
                level.neighborChanged(pos.relative(this.side.getOpposite()), blockState.getBlock(), orientation);
                if (strongPower) {
                    level.updateNeighborsAt(pos.relative(this.side.getOpposite()), blockState.getBlock());
                }
            }
        }

        @Override
        public int getRedstoneLevel() {
            EnumFacingMap<Integer> redstoneLevels = this.holder.redstoneLevels.get(this.dimPos);
            if (redstoneLevels != null) {
                return (Integer)redstoneLevels.getOrDefault((Object)this.side, (Object)-1);
            }
            return -1;
        }

        @Override
        public boolean isDirect() {
            EnumFacingMap<Boolean> redstoneStrongs = this.holder.redstoneStrong.get(this.dimPos);
            if (redstoneStrongs != null) {
                return (Boolean)redstoneStrongs.getOrDefault((Object)this.side, (Object)false);
            }
            return false;
        }

        @Override
        public void setAllowRedstoneInput(boolean allow) {
        }

        @Override
        public boolean isAllowRedstoneInput() {
            return false;
        }

        @Override
        public void setLastPulseValue(int value) {
        }

        @Override
        public int getLastPulseValue() {
            return 0;
        }
    }
}

