/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.capability.path;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integrateddynamics.api.path.IPathElement;
import org.cyclops.integrateddynamics.api.path.ISidedPathElement;
import org.cyclops.integrateddynamics.api.path.SidedPathElementParams;

public class SidedPathElement
implements ISidedPathElement {
    private final IPathElement pathElement;
    private final Direction side;

    public SidedPathElement(IPathElement pathElement, @Nullable Direction side) {
        this.pathElement = pathElement;
        this.side = side;
    }

    @Override
    public IPathElement getPathElement() {
        return this.pathElement;
    }

    @Override
    @Nullable
    public Direction getSide() {
        return this.side;
    }

    @Override
    public SidedPathElementParams getParams() {
        DimPos pos = this.getPathElement().getPosition();
        return new SidedPathElementParams(pos.getLevel(), pos.getBlockPos(), Optional.ofNullable(this.getSide()));
    }

    public boolean equals(Object o) {
        return o instanceof ISidedPathElement && this.compareTo((ISidedPathElement)o) == 0;
    }

    @Override
    public int compareTo(ISidedPathElement o) {
        int pathElement = this.getPathElement().getPosition().compareTo(o.getPathElement().getPosition());
        if (pathElement == 0) {
            Direction thisSide = this.getSide();
            Direction thatSide = o.getSide();
            return thisSide != null && thatSide != null ? thisSide.compareTo((Enum)thatSide) : 0;
        }
        return pathElement;
    }

    public int hashCode() {
        return this.getPathElement().getPosition().hashCode();
    }

    public String toString() {
        return "[Sided PE: " + String.valueOf(this.getPathElement().getPosition()) + " @ " + String.valueOf(this.getSide()) + "]";
    }

    public static SidedPathElement of(IPathElement pathElement, @Nullable Direction side) {
        return new SidedPathElement(pathElement, side);
    }
}

