/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.player.Inventory;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonImage;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenScrolling;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.client.gui.image.Images;
import org.cyclops.integrateddynamics.core.client.gui.container.DisplayErrorsComponent;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipartAspects;

public abstract class ContainerScreenMultipartAspects<P extends IPartType<P, S>, S extends IPartState<P>, A extends IAspect<?, ?>, C extends ContainerMultipartAspects<P, S, A>>
extends ContainerScreenScrolling<C> {
    private static final Rectangle ITEM_POSITION = new Rectangle(8, 17, 18, 18);
    protected final DisplayErrorsComponent displayErrors = new DisplayErrorsComponent();
    private Map<IAspect, ButtonText> aspectPropertyButtons = Maps.newHashMap();

    public ContainerScreenMultipartAspects(C container, Inventory inventory, Component title) {
        super(container, inventory, title);
    }

    protected Rectangle getScrollRegion() {
        return new Rectangle(this.leftPos + 9, this.topPos + 18, 160, 105);
    }

    public void init() {
        this.clearWidgets();
        super.init();
        if (((ContainerMultipartAspects)this.getMenu()).getPartType().getContainerProviderSettings(null).isPresent()) {
            this.addRenderableWidget((GuiEventListener)new ButtonImage(this.leftPos - 20, this.topPos + 0, 18, 18, (Component)Component.translatable((String)"gui.integrateddynamics.partsettings"), this.createServerPressable(ContainerMultipartAspects.BUTTON_SETTINGS, button -> {}), new IImage[]{Images.BUTTON_BACKGROUND_INACTIVE, Images.BUTTON_MIDDLE_SETTINGS}, false, 0, 0));
            if (((ContainerMultipartAspects)this.getMenu()).getPartType().supportsOffsets()) {
                this.addRenderableWidget((GuiEventListener)new ButtonImage(this.leftPos - 20, this.topPos + 20, 18, 18, (Component)Component.translatable((String)"gui.integrateddynamics.part_offsets"), this.createServerPressable(ContainerMultipartAspects.BUTTON_OFFSETS, button -> {}), new IImage[]{Images.BUTTON_BACKGROUND_INACTIVE, Images.BUTTON_MIDDLE_OFFSET}, false, 0, 0));
            }
        }
        for (Map.Entry<IAspect, String> entry : ((ContainerMultipartAspects)this.getMenu()).getAspectPropertyButtons().entrySet()) {
            ButtonText button2 = new ButtonText(-20, -20, 10, 10, (Component)Component.translatable((String)"gui.integrateddynamics.aspect_settings"), (Component)Component.literal((String)"+"), this.createServerPressable(entry.getValue(), b -> {}), true);
            this.aspectPropertyButtons.put(entry.getKey(), button2);
            this.addRenderableWidget((GuiEventListener)button2);
        }
    }

    protected abstract String getNameId();

    protected ResourceLocation constructGuiTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)("textures/gui/" + this.getNameId() + ".png"));
    }

    protected float colorSmoothener(float color) {
        return 1.0f - (1.0f - color) / 4.0f;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        for (Map.Entry<IAspect, ButtonText> entry : this.aspectPropertyButtons.entrySet()) {
            entry.getValue().setX(-20);
            entry.getValue().setY(-20);
        }
        IModHelpers.get().getRenderHelpers().drawScaledCenteredString(guiGraphics, this.font, this.title.getString(), this.leftPos + this.offsetX + 6, this.topPos + this.offsetY + 10, 70, ARGB.opaque((int)0x404040), false, Font.DisplayMode.NORMAL);
        ContainerMultipartAspects container = (ContainerMultipartAspects)this.getMenu();
        int aspectBoxHeight = container.getAspectBoxHeight();
        for (int i = 0; i < container.getPageSize(); ++i) {
            if (!container.isElementVisible(i)) continue;
            IAspect aspect = (IAspect)container.getVisibleElement(i);
            Triple rgb = IModHelpers.get().getBaseHelpers().intToRGB(aspect.getValueType().getDisplayColor());
            int color = ARGB.colorFromFloat((float)1.0f, (float)this.colorSmoothener(((Float)rgb.getLeft()).floatValue()), (float)this.colorSmoothener(((Float)rgb.getMiddle()).floatValue()), (float)this.colorSmoothener(((Float)rgb.getRight()).floatValue()));
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, this.leftPos + this.offsetX + 9, this.topPos + this.offsetY + 18 + aspectBoxHeight * i, 0.0f, (float)this.getBaseYSize(), 160, aspectBoxHeight - 1, 256, 256, color);
            String aspectName = IModHelpers.get().getL10NHelpers().localize(aspect.getTranslationKey(), new Object[0]);
            IModHelpers.get().getRenderHelpers().drawScaledCenteredString(guiGraphics, this.font, aspectName, this.leftPos + this.offsetX + 26, this.topPos + this.offsetY + 25 + aspectBoxHeight * i, this.getMaxLabelWidth(), IModHelpers.get().getBaseHelpers().RGBAToInt(40, 40, 40, 255), false, Font.DisplayMode.NORMAL);
            this.drawAdditionalElementInfo(guiGraphics, container, i, aspect);
            if (!this.aspectPropertyButtons.containsKey(aspect)) continue;
            ButtonText button = this.aspectPropertyButtons.get(aspect);
            button.setX(this.leftPos + this.offsetX + 116);
            button.setY(this.topPos + this.offsetY + 20 + aspectBoxHeight * i);
        }
    }

    protected abstract void drawAdditionalElementInfo(GuiGraphics var1, C var2, int var3, A var4);

    protected Rectangle getElementPosition(C container, int i, boolean absolute) {
        return new Rectangle(ContainerScreenMultipartAspects.ITEM_POSITION.x + this.offsetX + (absolute ? this.leftPos : 0), ContainerScreenMultipartAspects.ITEM_POSITION.y + ((ContainerMultipartAspects)((Object)container)).getAspectBoxHeight() * i + this.offsetY + (absolute ? this.topPos : 0), ContainerScreenMultipartAspects.ITEM_POSITION.width, ContainerScreenMultipartAspects.ITEM_POSITION.height);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ContainerMultipartAspects container = (ContainerMultipartAspects)this.getMenu();
        for (int i = 0; i < container.getPageSize(); ++i) {
            int y;
            ButtonText button;
            int x;
            if (!container.isElementVisible(i)) continue;
            if (this.isPointInRegion(this.getElementPosition(container, i, false), new Point(mouseX, mouseY))) {
                LinkedList lines = Lists.newLinkedList();
                ((IAspect)container.getVisibleElement(i)).loadTooltip(lines::add, true);
                this.drawTooltip(lines, guiGraphics, mouseX, mouseY);
            }
            this.drawAdditionalElementInfoForeground(guiGraphics, container, i, (IAspect)container.getVisibleElement(i), mouseX, mouseY);
            IAspect aspect = (IAspect)container.getVisibleElement(i);
            if (!this.aspectPropertyButtons.containsKey(aspect) || !this.isHovering(x = (button = this.aspectPropertyButtons.get(aspect)).getX() - this.leftPos, y = button.getY() - this.topPos, button.getWidth(), button.getHeight(), mouseX, mouseY)) continue;
            LinkedList lines = Lists.newLinkedList();
            lines.add(Component.translatable((String)"gui.integrateddynamics.part.properties").withStyle(ChatFormatting.WHITE));
            for (IAspectPropertyTypeInstance property : aspect.getPropertyTypes()) {
                lines.add(Component.literal((String)"-").withStyle(ChatFormatting.YELLOW).append((Component)Component.translatable((String)property.getTranslationKey())));
            }
            this.drawTooltip(lines, guiGraphics, mouseX, mouseY);
        }
        if (this.isHovering(-20, 0, 18, 18, mouseX, mouseY)) {
            this.drawTooltip(Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"gui.integrateddynamics.part_settings")}), guiGraphics, mouseX, mouseY);
        }
        if (this.isHovering(-20, 20, 18, 18, mouseX, mouseY)) {
            this.drawTooltip(Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"gui.integrateddynamics.part_offsets")}), guiGraphics, mouseX, mouseY);
        }
    }

    protected abstract void drawAdditionalElementInfoForeground(GuiGraphics var1, C var2, int var3, A var4, int var5, int var6);

    public int getMaxLabelWidth() {
        return 63;
    }
}

