/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeBooleanLPElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;

public class ValueTypeBoolean
extends ValueTypeBase<ValueBoolean> {
    public ValueTypeBoolean() {
        super("boolean", IModHelpers.get().getBaseHelpers().RGBToInt(43, 47, 231), ChatFormatting.BLUE, ValueBoolean.class);
    }

    @Override
    public ValueBoolean getDefault() {
        return ValueBoolean.of(false);
    }

    @Override
    public MutableComponent toCompactString(ValueBoolean value) {
        return Component.literal((String)Boolean.toString(value.getRawValue()));
    }

    @Override
    public void serialize(ValueOutput valueOutput, ValueBoolean value) {
        valueOutput.putBoolean("v", value.getRawValue());
    }

    @Override
    public ValueBoolean deserialize(ValueInput valueInput) {
        return ValueBoolean.of(valueInput.getBooleanOr("v", false));
    }

    @Override
    public String toString(ValueBoolean value) {
        return Boolean.toString(value.getRawValue());
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeBooleanLPElement((IValueType)this);
    }

    @Override
    public ValueBoolean parseString(String value) throws EvaluationException {
        boolean b;
        if ("true".equalsIgnoreCase(value) || "1".equals(value)) {
            b = true;
        } else if ("false".equalsIgnoreCase(value) || "0".equals(value)) {
            b = false;
        } else {
            throw new EvaluationException(Component.translatable((String)"operator.integrateddynamics.error.parse", (Object[])new Object[]{value, Component.translatable((String)this.getTranslationKey())}));
        }
        return ValueBoolean.of(b);
    }

    public static class ValueBoolean
    extends ValueBase {
        private static final ValueBoolean TRUE = new ValueBoolean(true);
        private static final ValueBoolean FALSE = new ValueBoolean(false);
        private final boolean value;

        private ValueBoolean(boolean value) {
            super(ValueTypes.BOOLEAN);
            this.value = value;
        }

        public static ValueBoolean of(boolean value) {
            return value ? TRUE : FALSE;
        }

        public boolean getRawValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            return o instanceof ValueBoolean && ((ValueBoolean)o).value == this.value;
        }

        public int hashCode() {
            return this.getType().hashCode() + (this.value ? 1 : 0);
        }

        @Override
        public String toString() {
            return "ValueTypeBoolean.ValueBoolean(value=" + this.value + ")";
        }
    }
}

