/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.ingredient.recipe.IngredientRecipeHelpers;
import org.cyclops.cyclopscore.ingredient.recipe.RecipeHandlerRecipeType;
import org.cyclops.cyclopscore.recipe.type.IInventoryFluid;
import org.cyclops.cyclopscore.recipe.type.InventoryFluid;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeDryingBasin;

public class RecipeHandlerDryingBasin<T extends RecipeDryingBasin>
extends RecipeHandlerRecipeType<IInventoryFluid, T> {
    public RecipeHandlerDryingBasin(Supplier<Level> worldSupplier, RecipeType<T> recipeType) {
        super(worldSupplier, recipeType, (Set)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK, IngredientComponent.FLUIDSTACK}), (Set)Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK, IngredientComponent.FLUIDSTACK}));
    }

    @Nullable
    protected IInventoryFluid getRecipeInputContainer(IMixedIngredients input) {
        InventoryFluid inventory = new InventoryFluid(NonNullList.withSize((int)1, (Object)ItemStack.EMPTY), NonNullList.withSize((int)1, (Object)FluidStack.EMPTY));
        if (!input.getInstances(IngredientComponent.ITEMSTACK).isEmpty()) {
            inventory.setItem(0, (ItemStack)input.getInstances(IngredientComponent.ITEMSTACK).get(0));
        }
        if (!input.getInstances(IngredientComponent.FLUIDSTACK).isEmpty()) {
            inventory.getFluidHandler().fill((FluidStack)input.getInstances(IngredientComponent.FLUIDSTACK).get(0), IFluidHandler.FluidAction.EXECUTE);
        }
        return inventory;
    }

    @Nullable
    protected Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> getRecipeInputIngredients(RecipeDryingBasin recipe) {
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        if (recipe.getInputIngredient().isPresent()) {
            inputs.put(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new IPrototypedIngredientAlternatives[]{IngredientRecipeHelpers.getPrototypesFromIngredient((Ingredient)recipe.getInputIngredient().get())}));
        }
        if (recipe.getInputFluid().isPresent()) {
            inputs.put(IngredientComponent.FLUIDSTACK, Lists.newArrayList((Object[])new IPrototypedIngredientAlternatives[]{new PrototypedIngredientAlternativesList((List)Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient(IngredientComponent.FLUIDSTACK, (Object)recipe.getInputFluid().get(), (Object)7)}))}));
        }
        return inputs;
    }

    @Nullable
    protected IMixedIngredients getRecipeOutputIngredients(RecipeDryingBasin recipe) {
        IdentityHashMap outputIngredients = Maps.newIdentityHashMap();
        if (!recipe.getOutputItemFirst().isEmpty()) {
            outputIngredients.put(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new Optional[]{recipe.getOutputItemFirst()}));
        }
        if (!recipe.getOutputFluid().isEmpty()) {
            outputIngredients.put(IngredientComponent.FLUIDSTACK, Lists.newArrayList((Object[])new FluidStack[]{recipe.getOutputFluid().get()}));
        }
        if (outputIngredients.isEmpty()) {
            return null;
        }
        return new MixedIngredients((Map)outputIngredients);
    }

    public boolean isValidSizeInput(IngredientComponent<?, ?> ingredientComponent, int size) {
        return (ingredientComponent == IngredientComponent.ITEMSTACK || ingredientComponent == IngredientComponent.FLUIDSTACK) && size == 1;
    }
}

