/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.inventory.container;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.slot.SlotRemoveOnly;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectRead;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectVariable;
import org.cyclops.integrateddynamics.api.part.read.IPartStateReader;
import org.cyclops.integrateddynamics.api.part.read.IPartTypeReader;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipartAspects;
import org.cyclops.integrateddynamics.core.inventory.container.slot.SlotVariable;
import org.cyclops.integrateddynamics.core.part.event.PartReaderAspectEvent;

public class ContainerPartReader<P extends IPartTypeReader<P, S>, S extends IPartStateReader<P>>
extends ContainerMultipartAspects<P, S, IAspectRead<?, ?>> {
    public static final int ASPECT_BOX_HEIGHT = 36;
    private static final int SLOT_IN_X = 96;
    private static final int SLOT_IN_Y = 27;
    private static final int SLOT_OUT_X = 144;
    private static final int SLOT_OUT_Y = 27;
    private final Container outputSlots;
    private final BiMap<Integer, IAspectRead<?, ?>> readValueIds = HashBiMap.create();
    private final BiMap<Integer, IAspectRead<?, ?>> readColorIds = HashBiMap.create();

    public ContainerPartReader(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory, (RegistryFriendlyByteBuf)packetBuffer);
    }

    public ContainerPartReader(int id, Inventory playerInventory, RegistryFriendlyByteBuf packetBuffer) {
        this(id, playerInventory, (Container)new SimpleInventory(0, 1), PartHelpers.readPartTarget(packetBuffer), Optional.empty(), (IPartTypeReader)PartHelpers.readPart((FriendlyByteBuf)packetBuffer));
    }

    public ContainerPartReader(int id, Inventory playerInventory, Container inventory, PartTarget target, Optional<IPartContainer> partContainer, P partType) {
        super((MenuType)RegistryEntries.CONTAINER_PART_READER.get(), id, playerInventory, inventory, target, partContainer, partType, partType.getReadAspects());
        int i;
        for (i = 0; i < this.getUnfilteredItemCount(); ++i) {
            this.addSlot((Slot)new SlotVariable(this.inputSlots, i, 96, 27 + this.getAspectBoxHeight() * i));
            this.disableSlot(i);
        }
        this.outputSlots = new SimpleInventory(this.getUnfilteredItemCount(), 1);
        for (i = 0; i < this.getUnfilteredItemCount(); ++i) {
            this.addSlot((Slot)new SlotRemoveOnly(this.outputSlots, i, 144, 27 + this.getAspectBoxHeight() * i));
            this.disableSlot(i + this.getUnfilteredItemCount());
        }
        this.addPlayerInventory(this.player.getInventory(), 9, 131);
        for (IAspectRead aspectRead : this.getUnfilteredItems()) {
            this.readValueIds.put((Object)this.getNextValueId(), (Object)aspectRead);
            this.readColorIds.put((Object)this.getNextValueId(), (Object)aspectRead);
        }
    }

    protected boolean isAssertInventorySize() {
        return false;
    }

    protected int getSizeInventory() {
        return ((IPartTypeReader)this.getPartType()).getReadAspects().size() * 2;
    }

    @Override
    public int getAspectBoxHeight() {
        return 36;
    }

    @Override
    protected void enableSlot(int slotIndex, int row) {
        Slot slot = this.getSlot(slotIndex);
        ContainerPartReader.setSlotPosX((Slot)slot, (int)96);
        ContainerPartReader.setSlotPosY((Slot)slot, (int)(27 + this.getAspectBoxHeight() * row));
    }

    protected void disableSlotOutput(int slotIndex) {
        Slot slot = this.getSlot(slotIndex + this.getUnfilteredItemCount());
        ContainerPartReader.setSlotPosX((Slot)slot, (int)Integer.MIN_VALUE);
        ContainerPartReader.setSlotPosY((Slot)slot, (int)Integer.MIN_VALUE);
    }

    protected void enableSlotOutput(int slotIndex, int row) {
        Slot slot = this.getSlot(slotIndex + this.getUnfilteredItemCount());
        ContainerPartReader.setSlotPosX((Slot)slot, (int)144);
        ContainerPartReader.setSlotPosY((Slot)slot, (int)(27 + this.getAspectBoxHeight() * row));
    }

    @Override
    public void onScroll(int firstRow) {
        for (int i = 0; i < this.getUnfilteredItemCount(); ++i) {
            this.disableSlotOutput(i);
        }
        super.onScroll(firstRow);
    }

    @Override
    protected void enableElementAt(int row, int elementIndex, IAspectRead element) {
        super.enableElementAt(row, elementIndex, element);
        this.enableSlotOutput(elementIndex, row);
    }

    @Override
    public void removed(Player player) {
        super.removed(player);
        if (!player.level().isClientSide()) {
            for (int i = 0; i < this.getUnfilteredItemCount(); ++i) {
                ItemStack itemStack = this.inputSlots.removeItemNoUpdate(i);
                if (!itemStack.isEmpty()) {
                    player.drop(itemStack, false);
                }
                if ((itemStack = this.outputSlots.removeItemNoUpdate(i)).isEmpty()) continue;
                player.drop(itemStack, false);
            }
        }
    }

    public void onDirty() {
        for (int i = 0; i < this.getUnfilteredItemCount(); ++i) {
            ItemStack itemStack = this.inputSlots.getItem(i);
            if (itemStack.isEmpty() || !this.outputSlots.getItem(i).isEmpty()) continue;
            ItemStack outputStack = this.writeAspectInfo(!this.player.level().isClientSide(), itemStack.copy(), this.player.level(), (IAspect)this.getUnfilteredItems().get(i));
            this.outputSlots.setItem(i, outputStack);
            this.inputSlots.removeItem(i, 1);
        }
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        try {
            if (!this.player.level().isClientSide()) {
                for (IAspectRead aspectRead : this.getUnfilteredItems()) {
                    Pair<MutableComponent, Integer> readValue;
                    if (((IPartStateReader)this.getPartState()).isEnabled()) {
                        IAspectVariable variable = ((IPartTypeReader)this.getPartType()).getVariable(this.getTarget(), (IPartStateReader)this.getPartState(), aspectRead);
                        readValue = ValueHelpers.getSafeReadableValue(variable);
                    } else {
                        readValue = Pair.of((Object)Component.literal((String)"NO POWER"), (Object)0);
                    }
                    this.setReadValue(aspectRead, readValue);
                }
            }
        }
        catch (PartStateException e) {
            this.player.closeContainer();
        }
    }

    public void setReadValue(IAspectRead aspectRead, Pair<MutableComponent, Integer> readValue) {
        int valueId = (Integer)this.readValueIds.inverse().get((Object)aspectRead);
        int colorId = (Integer)this.readColorIds.inverse().get((Object)aspectRead);
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)valueId, (Component)((Component)readValue.getLeft()));
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)colorId, (int)((Integer)readValue.getRight()));
    }

    public Pair<Component, Integer> getReadValue(IAspectRead aspect) {
        int valueId = (Integer)this.readValueIds.inverse().get((Object)aspect);
        int colorId = (Integer)this.readColorIds.inverse().get((Object)aspect);
        try {
            return Pair.of((Object)ValueNotifierHelpers.getValueTextComponent((IValueNotifier)this, (int)valueId), (Object)ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)colorId));
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public ItemStack writeAspectInfo(boolean generateId, ItemStack itemStack, Level level, IAspect aspect) {
        ItemStack resultStack = super.writeAspectInfo(generateId, itemStack, level, aspect);
        if (this.player.level().isClientSide()) {
            return resultStack;
        }
        PartTarget target = this.getTarget();
        INetwork network = NetworkHelpers.getNetworkChecked((ILevelExtension)target.getCenter().getPos().getLevel(true), target.getCenter().getPos().getBlockPos(), target.getCenter().getSide());
        IPartNetwork partNetwork = NetworkHelpers.getPartNetworkChecked(network);
        PartReaderAspectEvent<IPartTypeReader, IPartStateReader, IAspectRead> event = new PartReaderAspectEvent<IPartTypeReader, IPartStateReader, IAspectRead>(network, partNetwork, target, (IPartTypeReader)this.getPartType(), (IPartStateReader)this.getPartState(), this.player, (IAspectRead)aspect, resultStack);
        NeoForge.EVENT_BUS.post(event);
        return event.getItemStack();
    }
}

