/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part.panel;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.event.INetworkEvent;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartTypeActiveVariable;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.block.IgnoredBlock;
import org.cyclops.integrateddynamics.core.block.IgnoredBlockStatus;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.helper.WrenchHelpers;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.core.part.PartStateActiveVariableBase;
import org.cyclops.integrateddynamics.core.part.PartStateBase;
import org.cyclops.integrateddynamics.core.part.PartTypeBase;
import org.cyclops.integrateddynamics.core.part.panel.PartTypePanel;
import org.cyclops.integrateddynamics.inventory.container.ContainerPartPanelVariableDriven;

public abstract class PartTypePanelVariableDriven<P extends PartTypePanelVariableDriven<P, S>, S extends State<P, S>>
extends PartTypePanel<P, S>
implements IPartTypeActiveVariable<P, S> {
    public PartTypePanelVariableDriven(String name) {
        super(name);
    }

    @Override
    protected Block createBlock(BlockConfig blockConfig) {
        return new IgnoredBlockStatus();
    }

    @Override
    protected Map<Class<? extends INetworkEvent>, PartTypeBase.IEventAction> constructNetworkEventActions() {
        Map<Class<? extends INetworkEvent>, PartTypeBase.IEventAction> actions = super.constructNetworkEventActions();
        PartTypeBase.IEventAction updateEventListener = (network, target, state, event) -> NetworkHelpers.getPartNetwork(network).ifPresent(partNetwork -> this.onVariableContentsUpdated((IPartNetwork)partNetwork, target, (S)state));
        actions.put(VariableContentsUpdatedEvent.class, updateEventListener);
        return actions;
    }

    @Override
    public void addDrops(PartTarget target, S state, List<ItemStack> itemStacks, boolean dropMainElement, boolean saveState) {
        for (int i = 0; i < ((PartStateActiveVariableBase)state).getInventory().getContainerSize(); ++i) {
            ItemStack itemStack = ((PartStateActiveVariableBase)state).getInventory().getItem(i);
            if (itemStack.isEmpty()) continue;
            itemStacks.add(itemStack);
        }
        ((PartStateActiveVariableBase)state).getInventory().clearContent();
        ((PartStateActiveVariableBase)state).onVariableContentsUpdated((PartTypePanelVariableDriven)this, target);
        super.addDrops(target, state, itemStacks, dropMainElement, saveState);
    }

    @Override
    public boolean isUpdate(S state) {
        return true;
    }

    @Override
    public void update(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        Level level;
        IValue newValue;
        IValue lastValue;
        block7: {
            super.update(network, partNetwork, target, state);
            lastValue = ((State)state).getDisplayValue();
            newValue = null;
            level = target.getCenter().getPos().getLevel(true);
            if (((PartStateActiveVariableBase)state).hasVariable()) {
                try {
                    IVariable variable = ((PartStateActiveVariableBase)state).getVariable(network, partNetwork, ValueDeseralizationContext.of(level));
                    if (variable != null) {
                        newValue = (IValue)variable.getValue();
                        if (((PartStateActiveVariableBase)state).isRetryEvaluation()) {
                            ((PartStateActiveVariableBase)state).setRetryEvaluation(false);
                            ((PartStateActiveVariableBase)state).addGlobalError(null);
                        }
                    }
                }
                catch (EvaluationException e) {
                    if (((PartStateActiveVariableBase)state).isRetryEvaluation()) break block7;
                    ((PartStateActiveVariableBase)state).addGlobalError(e.getErrorMessage());
                    if (e.isRetryEvaluation()) {
                        ((PartStateActiveVariableBase)state).setRetryEvaluation(true);
                    }
                    e.addResolutionListeners(() -> state.onVariableContentsUpdated(this, target));
                }
            }
        }
        if (!ValueHelpers.areValuesEqual(lastValue, newValue)) {
            this.onValueChanged(network, partNetwork, target, state, lastValue, newValue);
            ((PartStateBase)state).onDirty();
            BlockHelpers.markForUpdate((Level)level, (BlockPos)target.getCenter().getPos().getBlockPos());
        }
    }

    @Override
    public boolean hasActiveVariable(IPartNetwork network, PartTarget target, S partState) {
        return ((PartStateActiveVariableBase)partState).hasVariable();
    }

    @Override
    public <V extends IValue> IVariable<V> getActiveVariable(INetwork network, IPartNetwork partNetwork, PartTarget target, S partState) {
        return ((PartStateActiveVariableBase)partState).getVariable(network, partNetwork, ValueDeseralizationContext.of(target.getCenter().getPos().getLevel(true)));
    }

    protected void onValueChanged(INetwork network, IPartNetwork partNetwork, PartTarget target, S state, IValue lastValue, IValue newValue) {
        if (newValue == null) {
            ((State)state).setDisplayValue(null);
        } else {
            IValue materializedValue = null;
            try {
                IValueTypeListProxy original;
                if (newValue.getType() == ValueTypes.LIST && (original = ((ValueTypeList.ValueList)newValue).getRawValue()).getLength() > 20) {
                    ArrayList list = Lists.newArrayList();
                    for (int i = 0; i < 20; ++i) {
                        list.add(original.get(i));
                    }
                    newValue = ValueTypeList.ValueList.ofList(original.getValueType(), list);
                }
                materializedValue = newValue.getType().materialize(newValue);
            }
            catch (EvaluationException e) {
                ((PartStateActiveVariableBase)state).addGlobalError(e.getErrorMessage());
                e.addResolutionListeners(() -> state.addGlobalError(null));
            }
            ((State)state).setDisplayValue(materializedValue);
        }
    }

    @Override
    public Optional<MenuProvider> getContainerProvider(final PartPos pos) {
        return Optional.of(new MenuProvider(){

            public Component getDisplayName() {
                return Component.translatable((String)PartTypePanelVariableDriven.this.getTranslationKey());
            }

            @Nullable
            public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
                Triple<IPartContainer, PartTypeBase, PartTarget> data = PartHelpers.getContainerPartConstructionData(pos);
                State partState = (State)((IPartContainer)data.getLeft()).getPartState(((PartTarget)data.getRight()).getCenter().getSide());
                return new ContainerPartPanelVariableDriven(id, playerInventory, (Container)partState.getInventory(), Optional.of((PartTarget)data.getRight()), Optional.of((IPartContainer)data.getLeft()), (PartTypePanelVariableDriven)data.getMiddle());
            }

            public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                return false;
            }
        });
    }

    @Override
    public void writeExtraGuiData(RegistryFriendlyByteBuf packetBuffer, PartPos pos, ServerPlayer player) {
        IPartContainer partContainer = PartHelpers.getPartContainerChecked(pos);
        State partState = (State)partContainer.getPartState(pos.getSide());
        packetBuffer.writeInt(partState.getInventory().getContainerSize());
        super.writeExtraGuiData(packetBuffer, pos, player);
    }

    protected IgnoredBlockStatus.Status getStatus(State state) {
        IgnoredBlockStatus.Status status = IgnoredBlockStatus.Status.INACTIVE;
        if (state != null && !state.getInventory().isEmpty()) {
            status = state.hasVariable() && state.isEnabled() ? IgnoredBlockStatus.Status.ACTIVE : IgnoredBlockStatus.Status.ERROR;
        }
        return status;
    }

    @Override
    public BlockState getBlockState(IPartContainer partContainer, Direction side) {
        IgnoredBlockStatus.Status status = this.getStatus(partContainer != null ? (State)partContainer.getPartState(side) : null);
        return (BlockState)((BlockState)this.getBlock().defaultBlockState().setValue((Property)IgnoredBlock.FACING, (Comparable)side)).setValue((Property)IgnoredBlockStatus.STATUS, (Comparable)((Object)status));
    }

    protected void onVariableContentsUpdated(IPartNetwork network, PartTarget target, S state) {
        ((PartStateActiveVariableBase)state).onVariableContentsUpdated((PartTypePanelVariableDriven)this, target);
    }

    @Override
    public InteractionResult onPartActivated(S partState, BlockPos pos, Level world, Player player, InteractionHand hand, ItemStack heldItem, BlockHitResult hit) {
        if (WrenchHelpers.isWrench(player, heldItem, world, pos, hit.getDirection())) {
            WrenchHelpers.wrench(player, heldItem, world, pos, hit.getDirection(), (player1, pos1, parameter) -> partState.setFacingRotation(partState.getFacingRotation().getClockWise()));
            return InteractionResult.SUCCESS;
        }
        return super.onPartActivated(partState, pos, world, player, hand, heldItem, hit);
    }

    @Override
    public void loadTooltip(S state, List<Component> lines) {
        if (!((PartStateActiveVariableBase)state).getInventory().isEmpty()) {
            if (((PartStateActiveVariableBase)state).hasVariable() && ((PartStateBase)state).isEnabled()) {
                IValue value = ((State)state).getDisplayValue();
                if (value != null) {
                    IValueType valueType = value.getType();
                    lines.add((Component)Component.translatable((String)"parttype.integrateddynamics.tooltip.display.active_value", (Object[])new Object[]{valueType.toCompactString(value).withStyle(valueType.getDisplayColorFormat()), Component.translatable((String)valueType.getTranslationKey())}));
                }
            } else {
                lines.add((Component)Component.translatable((String)"parttype.integrateddynamics.tooltip.errors").withStyle(ChatFormatting.RED));
                for (MutableComponent error : ((PartStateActiveVariableBase)state).getGlobalErrors()) {
                    lines.add((Component)error.withStyle(ChatFormatting.RED));
                }
            }
        } else {
            lines.add((Component)Component.translatable((String)"parttype.integrateddynamics.tooltip.inactive"));
        }
        super.loadTooltip(state, lines);
    }

    @Override
    public boolean shouldTriggerBlockRenderUpdate(@Nullable S oldPartState, @Nullable S newPartState) {
        return super.shouldTriggerBlockRenderUpdate(oldPartState, newPartState) || this.getStatus((State)oldPartState) != this.getStatus((State)newPartState);
    }

    public static abstract class State<P extends PartTypePanelVariableDriven<P, S>, S extends State<P, S>>
    extends PartStateActiveVariableBase<P> {
        private IValue displayValue;
        private Direction facingRotation = Direction.NORTH;

        public State() {
            super(1);
        }

        @Override
        public void writeToNBT(ValueDeseralizationContext valueDeseralizationContext, CompoundTag tag) {
            super.writeToNBT(valueDeseralizationContext, tag);
            IValue value = this.getDisplayValue();
            if (value != null) {
                tag.putString("displayValueType", value.getType().getUniqueName().toString());
                tag.put("displayValue", ValueHelpers.serializeRaw(valueDeseralizationContext, value));
            }
            tag.putInt("facingRotation", this.facingRotation.ordinal());
        }

        @Override
        public void readFromNBT(ValueDeseralizationContext valueDeseralizationContext, CompoundTag tag) {
            super.readFromNBT(valueDeseralizationContext, tag);
            if (tag.contains("displayValueType", 8) && tag.contains("displayValue")) {
                IValueType valueType = ValueTypes.REGISTRY.getValueType(ResourceLocation.parse((String)tag.getString("displayValueType")));
                if (valueType != null) {
                    Tag serializedValue = tag.get("displayValue");
                    Component deserializationError = valueType.canDeserialize(valueDeseralizationContext, serializedValue);
                    if (deserializationError == null) {
                        this.setDisplayValue((IValue)ValueHelpers.deserializeRaw(valueDeseralizationContext, valueType, serializedValue));
                    } else {
                        IntegratedDynamics.clog(org.apache.logging.log4j.Level.ERROR, deserializationError.getString());
                    }
                } else {
                    IntegratedDynamics.clog(org.apache.logging.log4j.Level.ERROR, String.format("Tried to deserialize the value \"%s\" for type \"%s\" which could not be found.", tag.getString("displayValueType"), tag.getString("value")));
                }
            } else {
                this.setDisplayValue(null);
            }
            this.facingRotation = Direction.values()[Math.max(2, tag.getInt("facingRotation"))];
        }

        public IValue getDisplayValue() {
            return this.displayValue;
        }

        public void setDisplayValue(IValue displayValue) {
            this.displayValue = displayValue;
        }

        public Direction getFacingRotation() {
            return this.facingRotation;
        }

        public void setFacingRotation(Direction facingRotation) {
            this.facingRotation = facingRotation;
        }
    }
}

