/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.api.advancement.criterion.ValuePredicate;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxyFactoryTypeRegistry;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyFactories;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyMaterialized;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeListLPElement;

public class ValueTypeList
extends ValueObjectTypeBase<ValueList> {
    public static final int MAX_RENDER_LINES = 20;

    public ValueTypeList() {
        super("list", Helpers.RGBToInt((int)175, (int)3, (int)1), ChatFormatting.DARK_RED, ValueList.class);
    }

    @Override
    public ValueList getDefault() {
        return ValueList.ofList(ValueTypes.CATEGORY_ANY, Collections.emptyList());
    }

    @Override
    public MutableComponent toCompactString(ValueList value) {
        return value.getRawValue().toCompactString();
    }

    @Override
    public Tag serialize(ValueDeseralizationContext valueDeseralizationContext, ValueList value) {
        try {
            return ValueTypeListProxyFactories.REGISTRY.serialize(valueDeseralizationContext, value.getRawValue());
        }
        catch (IValueTypeListProxyFactoryTypeRegistry.SerializationException e) {
            e.printStackTrace();
            return new CompoundTag();
        }
    }

    @Override
    public Component canDeserialize(ValueDeseralizationContext valueDeseralizationContext, Tag value) {
        try {
            Object proxy = ValueTypeListProxyFactories.REGISTRY.deserialize(valueDeseralizationContext, value);
            return null;
        }
        catch (IValueTypeListProxyFactoryTypeRegistry.SerializationException e) {
            return Component.translatable((String)e.getMessage());
        }
    }

    @Override
    public ValueList deserialize(ValueDeseralizationContext valueDeseralizationContext, Tag value) {
        if (!(value.getId() == 0 || value.getId() == 10 && ((CompoundTag)value).isEmpty())) {
            try {
                Object proxy = ValueTypeListProxyFactories.REGISTRY.deserialize(valueDeseralizationContext, value);
                return ValueList.ofFactory(proxy);
            }
            catch (IValueTypeListProxyFactoryTypeRegistry.SerializationException e) {
                e.printStackTrace();
            }
        }
        return this.getDefault();
    }

    @Override
    public ValueList materialize(ValueList value) throws EvaluationException {
        IValueTypeListProxy list = value.getRawValue();
        if (list.isInfinite()) {
            return ValueList.ofList(list.getValueType(), Lists.newArrayList((Object[])new IValue[]{list.get(0)}));
        }
        ArrayList values = Lists.newArrayListWithExpectedSize((int)list.getLength());
        for (IValue listValue : list) {
            values.add(listValue.getType().materialize(listValue));
        }
        return ValueList.ofList(list.getValueType(), values);
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeListLPElement();
    }

    public static class ValueList<T extends IValueType<V>, V extends IValue>
    extends ValueBase {
        private final IValueTypeListProxy<T, V> value;

        private ValueList(IValueTypeListProxy<T, V> value) {
            super(ValueTypes.LIST);
            this.value = value;
        }

        public static <T extends IValueType<V>, V extends IValue> ValueList ofList(T valueType, List<V> values) {
            return new ValueList<T, V>(new ValueTypeListProxyMaterialized<T, V>(valueType, values));
        }

        public static <V extends IValue> ValueList ofAll(V ... values) {
            return values.length == 0 ? ValueTypes.LIST.getDefault() : ValueList.ofList(values[0].getType(), ImmutableList.copyOf((Object[])values));
        }

        public static <V extends IValue> ValueList ofAll(IValueType type, V ... values) {
            return ValueList.ofList(type, ImmutableList.copyOf((Object[])values));
        }

        public static <T extends IValueType<V>, V extends IValue> ValueList ofFactory(IValueTypeListProxy<T, V> proxy) {
            return new ValueList<T, V>(proxy);
        }

        public IValueTypeListProxy<T, V> getRawValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            return o instanceof ValueList && ((ValueList)o).value.equals(this.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public String toString() {
            return "ValueTypeList.ValueList(value=" + String.valueOf(this.value) + ")";
        }
    }

    public static class ValueListPredicate
    extends ValuePredicate<ValueList> {
        private final Optional<Boolean> infinite;

        public ValueListPredicate(Optional<Boolean> infinite) {
            super(Optional.of(ValueTypes.LIST), Optional.empty(), Optional.empty());
            this.infinite = infinite;
        }

        public Optional<Boolean> getInfinite() {
            return this.infinite;
        }

        @Override
        protected boolean testTyped(ValueList value) {
            return super.testTyped(value) && (this.infinite.isEmpty() || value.getRawValue().isInfinite() == this.infinite.get().booleanValue());
        }
    }

    public static class ListFactoryIterator<T extends IValueType<V>, V extends IValue>
    implements Iterator<V> {
        private final IValueTypeListProxy<T, V> value;
        private int index = 0;
        private int length;

        public ListFactoryIterator(IValueTypeListProxy<T, V> value) {
            this.value = value;
            try {
                this.length = this.value.getLength();
            }
            catch (EvaluationException e) {
                this.length = 0;
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < this.length;
        }

        @Override
        public V next() {
            try {
                return this.value.get(this.index++);
            }
            catch (EvaluationException e) {
                e.printStackTrace();
                return this.value.getValueType().getDefault();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

