/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.helper.RecipeSerializerHelpers;
import org.cyclops.cyclopscore.recipe.ItemStackFromIngredient;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeDryingBasin;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeMechanicalDryingBasin;

public class RecipeSerializerMechanicalDryingBasin
implements RecipeSerializer<RecipeMechanicalDryingBasin> {
    public static final MapCodec<RecipeMechanicalDryingBasin> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.optionalFieldOf("input_item").forGetter(RecipeDryingBasin::getInputIngredient), (App)FluidStack.CODEC.optionalFieldOf("input_fluid").forGetter(RecipeDryingBasin::getInputFluid), (App)RecipeSerializerHelpers.getCodecItemStackOrTag(() -> GeneralConfig.recipeTagOutputModPriorities).optionalFieldOf("output_item").forGetter(RecipeDryingBasin::getOutputItem), (App)FluidStack.CODEC.optionalFieldOf("output_fluid").forGetter(RecipeDryingBasin::getOutputFluid), (App)Codec.INT.fieldOf("duration").forGetter(RecipeDryingBasin::getDuration)).apply((Applicative)builder, (inputItem, inputFluid, outputItem, outputFluid, duration) -> {
        if (inputItem.isEmpty() && inputFluid.isEmpty()) {
            throw new JsonSyntaxException("An input item or fluid is required");
        }
        if (outputItem.isEmpty() && outputFluid.isEmpty()) {
            throw new JsonSyntaxException("An output item or fluid is required");
        }
        if (inputFluid.isPresent() && outputFluid.isPresent()) {
            throw new JsonSyntaxException("Can't have both an input and output fluid");
        }
        if (duration <= 0) {
            throw new JsonSyntaxException("Durations must be higher than one tick");
        }
        return new RecipeMechanicalDryingBasin((Optional<Ingredient>)inputItem, (Optional<FluidStack>)inputFluid, (Optional<Either<ItemStack, ItemStackFromIngredient>>)outputItem, (Optional<FluidStack>)outputFluid, (int)duration);
    }));
    public static final StreamCodec<RegistryFriendlyByteBuf, RecipeMechanicalDryingBasin> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC), RecipeDryingBasin::getInputIngredient, (StreamCodec)ByteBufCodecs.optional((StreamCodec)FluidStack.STREAM_CODEC), RecipeDryingBasin::getInputFluid, (StreamCodec)ByteBufCodecs.optional((StreamCodec)RecipeSerializerHelpers.STREAM_CODEC_ITEMSTACK_OR_TAG), RecipeDryingBasin::getOutputItem, (StreamCodec)ByteBufCodecs.optional((StreamCodec)FluidStack.STREAM_CODEC), RecipeDryingBasin::getOutputFluid, (StreamCodec)ByteBufCodecs.INT, RecipeDryingBasin::getDuration, RecipeMechanicalDryingBasin::new);

    public MapCodec<RecipeMechanicalDryingBasin> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, RecipeMechanicalDryingBasin> streamCodec() {
        return STREAM_CODEC;
    }
}

