/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeLong;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.Helpers;

public class NbtHelpers {
    public static boolean nbtMatchesSubset(CompoundTag a, CompoundTag b, boolean recursive) {
        for (String key : a.getAllKeys()) {
            Tag valueA = a.get(key);
            if (recursive && (valueA instanceof CompoundTag || valueA instanceof ListTag)) {
                CompoundTag tagB;
                CompoundTag tagA;
                Tag valueB = b.get(key);
                if (valueA instanceof CompoundTag) {
                    if (!(valueB instanceof CompoundTag)) {
                        return false;
                    }
                    tagA = (CompoundTag)valueA;
                    tagB = (CompoundTag)valueB;
                    if (NbtHelpers.nbtMatchesSubset(tagA, tagB, recursive)) continue;
                    return false;
                }
                if (!(valueA instanceof ListTag)) continue;
                if (!(valueB instanceof ListTag)) {
                    return false;
                }
                tagA = (ListTag)valueA;
                tagB = (ListTag)valueB;
                for (int i = 0; i < tagA.size(); ++i) {
                    CompoundTag subTagA = tagA.getCompound(i);
                    boolean foundA = false;
                    for (int j = 0; j < tagB.size(); ++j) {
                        CompoundTag subTagB = tagB.getCompound(j);
                        if (!NbtHelpers.nbtMatchesSubset(subTagA, subTagB, recursive)) continue;
                        foundA = true;
                        break;
                    }
                    if (foundA) continue;
                    return false;
                }
                continue;
            }
            if (valueA.equals((Object)b.get(key))) continue;
            return false;
        }
        return true;
    }

    public static CompoundTag union(CompoundTag ... tags) {
        CompoundTag tag = new CompoundTag();
        for (CompoundTag inputTag : tags) {
            tag.merge(inputTag);
        }
        return tag;
    }

    public static CompoundTag intersection(CompoundTag ... tags) {
        if (tags.length == 0) {
            return new CompoundTag();
        }
        CompoundTag tag = null;
        for (CompoundTag inputTag : tags) {
            if (tag == null) {
                tag = inputTag.copy();
                continue;
            }
            HashSet keys = Sets.newHashSet((Iterable)tag.getAllKeys());
            for (String key : keys) {
                byte type;
                if (!inputTag.contains(key, (int)(type = tag.get(key).getId()))) {
                    tag.remove(key);
                    continue;
                }
                if (type != 10) continue;
                tag.put(key, (Tag)NbtHelpers.intersection(tag.getCompound(key), inputTag.getCompound(key)));
            }
        }
        return tag;
    }

    public static CompoundTag minus(CompoundTag a, CompoundTag b) {
        CompoundTag tag = a.copy();
        for (String key : b.getAllKeys()) {
            byte type;
            if (!tag.contains(key, (int)(type = b.get(key).getId()))) continue;
            if (type == 10) {
                CompoundTag difference = NbtHelpers.minus(tag.getCompound(key), b.getCompound(key));
                if (difference.isEmpty()) {
                    tag.remove(key);
                    continue;
                }
                tag.put(key, (Tag)difference);
                continue;
            }
            tag.remove(key);
        }
        return tag;
    }

    public static ListTag getListNbtTag(ValueTypeList.ValueList<?, ?> value, Component operatorName) {
        ListTag list = new ListTag();
        for (IValue valueNbt : value.getRawValue()) {
            if (value.getRawValue().getValueType() != ValueTypes.NBT && (value.getRawValue().getValueType() != ValueTypes.CATEGORY_ANY || valueNbt.getType() != ValueTypes.NBT)) {
                MutableComponent error = Component.translatable((String)"operator.integrateddynamics.error.wrong_type", (Object[])new Object[]{operatorName, Component.translatable((String)value.getRawValue().getValueType().getTranslationKey()), 1, Component.translatable((String)ValueTypes.NBT.getTranslationKey())});
                Helpers.sneakyThrow(new EvaluationException(error));
            }
            ((ValueTypeNbt.ValueNbt)valueNbt).getRawValue().ifPresent(arg_0 -> list.add(arg_0));
        }
        return list;
    }

    public static ByteArrayTag getListNbtByte(ValueTypeList.ValueList<?, ?> value, Component operatorName) {
        LinkedList list = Lists.newLinkedList();
        for (IValue valueNbt : value.getRawValue()) {
            if (valueNbt.getType() != ValueTypes.INTEGER) {
                MutableComponent error = Component.translatable((String)"operator.integrateddynamics.error.wrong_type", (Object[])new Object[]{operatorName, Component.translatable((String)valueNbt.getType().getTranslationKey()), 1, Component.translatable((String)ValueTypes.INTEGER.getTranslationKey())});
                Helpers.sneakyThrow(new EvaluationException(error));
            }
            list.add((byte)((ValueTypeInteger.ValueInteger)valueNbt).getRawValue());
        }
        return new ByteArrayTag((List)list);
    }

    public static IntArrayTag getListNbtInt(ValueTypeList.ValueList<?, ?> value, Component operatorName) {
        LinkedList list = Lists.newLinkedList();
        for (IValue valueNbt : value.getRawValue()) {
            if (valueNbt.getType() != ValueTypes.INTEGER) {
                MutableComponent error = Component.translatable((String)"operator.integrateddynamics.error.wrong_type", (Object[])new Object[]{operatorName, Component.translatable((String)valueNbt.getType().getTranslationKey()), 1, Component.translatable((String)ValueTypes.INTEGER.getTranslationKey())});
                Helpers.sneakyThrow(new EvaluationException(error));
            }
            list.add(((ValueTypeInteger.ValueInteger)valueNbt).getRawValue());
        }
        return new IntArrayTag((List)list);
    }

    public static LongArrayTag getListNbtLong(ValueTypeList.ValueList<?, ?> value, Component operatorName) {
        LinkedList list = Lists.newLinkedList();
        for (IValue valueNbt : value.getRawValue()) {
            if (valueNbt.getType() != ValueTypes.LONG) {
                MutableComponent error = Component.translatable((String)"operator.integrateddynamics.error.wrong_type", (Object[])new Object[]{operatorName, Component.translatable((String)valueNbt.getType().getTranslationKey()), 1, Component.translatable((String)ValueTypes.LONG.getTranslationKey())});
                Helpers.sneakyThrow(new EvaluationException(error));
            }
            list.add(((ValueTypeLong.ValueLong)valueNbt).getRawValue());
        }
        return new LongArrayTag((List)list);
    }
}

