/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.blockentity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.cyclopscore.capability.item.ItemHandlerSlotMasked;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IValueTypeVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityActiveVariableBase;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityCableConnectableInventory;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.item.ValueTypeVariableFacade;
import org.cyclops.integrateddynamics.inventory.container.ContainerMaterializer;
import org.cyclops.integrateddynamics.network.MaterializerNetworkElement;

public class BlockEntityMaterializer
extends BlockEntityActiveVariableBase<MaterializerNetworkElement>
implements MenuProvider {
    public static final int INVENTORY_SIZE = 3;
    public static final int SLOT_READ = 0;
    public static final int SLOT_WRITE_IN = 1;
    public static final int SLOT_WRITE_OUT = 2;
    private Player lastPlayer = null;
    private boolean writeVariable;

    public BlockEntityMaterializer(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_MATERIALIZER, blockPos, blockState, 3);
        this.addCapabilitySided(ForgeCapabilities.ITEM_HANDLER, Direction.NORTH, LazyOptional.of(() -> new ItemHandlerSlotMasked((Container)this.getInventory(), new int[]{0})));
        this.addCapabilitySided(ForgeCapabilities.ITEM_HANDLER, Direction.SOUTH, LazyOptional.of(() -> new ItemHandlerSlotMasked((Container)this.getInventory(), new int[]{0})));
        this.addCapabilitySided(ForgeCapabilities.ITEM_HANDLER, Direction.EAST, LazyOptional.of(() -> new ItemHandlerSlotMasked((Container)this.getInventory(), new int[]{0})));
        this.addCapabilitySided(ForgeCapabilities.ITEM_HANDLER, Direction.WEST, LazyOptional.of(() -> new ItemHandlerSlotMasked((Container)this.getInventory(), new int[]{0})));
        this.addCapabilitySided(ForgeCapabilities.ITEM_HANDLER, Direction.UP, LazyOptional.of(() -> new ItemHandlerSlotMasked((Container)this.getInventory(), new int[]{1})));
        this.addCapabilitySided(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN, LazyOptional.of(() -> new ItemHandlerSlotMasked((Container)this.getInventory(), new int[]{2})));
        this.addCapabilityInternal(NetworkElementProviderConfig.CAPABILITY, LazyOptional.of(() -> new NetworkElementProviderSingleton(){

            @Override
            public INetworkElement createNetworkElement(Level world, BlockPos blockPos) {
                return new MaterializerNetworkElement(DimPos.of((Level)world, (BlockPos)blockPos));
            }
        }));
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new SimpleInventory(inventorySize, stackSize){

            public boolean m_7013_(int slot, ItemStack itemStack) {
                return slot != 2 && super.m_7013_(slot, itemStack);
            }
        };
    }

    @Override
    public int getSlotRead() {
        return 0;
    }

    protected boolean canWrite() {
        return NetworkHelpers.getPartNetwork(this.getNetwork()).map(partNetwork -> this.getVariable((IPartNetwork)partNetwork) != null && this.getEvaluator().getErrors().isEmpty()).orElse(false);
    }

    @Override
    public void onDirty() {
        super.onDirty();
        if (!this.f_58857_.m_5776_()) {
            this.writeVariable = true;
        }
    }

    public ItemStack writeMaterialized(boolean generateId, ItemStack itemStack) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        IVariable<?> variable = this.getVariable(NetworkHelpers.getPartNetworkChecked(this.getNetwork()));
        try {
            final Object value = variable.getType().materialize(variable.getValue());
            final IValueType valueType = value.getType();
            return registry.writeVariableFacadeItem(generateId, itemStack, ValueTypes.REGISTRY, new IVariableFacadeHandlerRegistry.IVariableFacadeFactory<IValueTypeVariableFacade>(){

                @Override
                public IValueTypeVariableFacade create(boolean generateId) {
                    return new ValueTypeVariableFacade<IValue>(generateId, valueType, value);
                }

                @Override
                public IValueTypeVariableFacade create(int id) {
                    return new ValueTypeVariableFacade<IValue>(id, valueType, value);
                }
            }, this.m_58904_(), this.lastPlayer, this.m_58900_());
        }
        catch (EvaluationException e) {
            this.getEvaluator().addError(Component.m_237115_((String)e.getMessage()));
            return ItemStack.f_41583_;
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerMaterializer(id, playerInventory, (Container)this.getInventory(), Optional.of(this));
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.integrateddynamics.materializer");
    }

    public void setLastPlayer(Player lastPlayer) {
        this.lastPlayer = lastPlayer;
    }

    public static class Ticker
    extends BlockEntityCableConnectableInventory.Ticker<BlockEntityMaterializer> {
        @Override
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityMaterializer blockEntity) {
            super.update(level, pos, blockState, blockEntity);
            if (blockEntity.writeVariable && !blockEntity.getInventory().m_8020_(1).m_41619_() && blockEntity.canWrite() && blockEntity.getInventory().m_8020_(2).m_41619_()) {
                blockEntity.writeVariable = false;
                ItemStack outputStack = blockEntity.writeMaterialized(!blockEntity.m_58904_().f_46443_, blockEntity.getInventory().m_8020_(1));
                if (!outputStack.m_41619_()) {
                    blockEntity.getInventory().m_6836_(2, outputStack);
                    blockEntity.getInventory().m_8016_(1);
                }
            }
        }
    }
}

