/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable.gui;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonCheckbox;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGuiBox;
import org.cyclops.integrateddynamics.core.evaluate.variable.gui.GuiElementValueTypeBoolean;
import org.cyclops.integrateddynamics.core.logicprogrammer.IRenderPatternValueTypeTooltip;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPattern;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerValueTypeBooleanValueChangedPacket;

@OnlyIn(value=Dist.CLIENT)
public class GuiElementValueTypeBooleanRenderPattern<S extends ISubGuiBox, G extends Screen, C extends AbstractContainerMenu>
extends RenderPattern<GuiElementValueTypeBoolean<G, C>, G, C>
implements IRenderPatternValueTypeTooltip {
    protected final GuiElementValueTypeBoolean<G, C> element;
    private boolean renderTooltip = true;
    private ButtonCheckbox checkbox = null;

    public GuiElementValueTypeBooleanRenderPattern(GuiElementValueTypeBoolean<G, C> element, int baseX, int baseY, int maxWidth, int maxHeight, G gui, C container) {
        super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
        this.element = element;
    }

    @Override
    public void init(int guiLeft, int guiTop) {
        super.init(guiLeft, guiTop);
        this.checkbox = new ButtonCheckbox(guiLeft + this.getX(), guiTop + this.getY(), ((GuiElementValueTypeBoolean)this.getElement()).getRenderPattern().getWidth(), ((GuiElementValueTypeBoolean)this.getElement()).getRenderPattern().getHeight(), (Component)Component.m_237115_((String)((GuiElementValueTypeBoolean)this.getElement()).getValueType().getTranslationKey()), entry -> this.onChecked(this.checkbox.isChecked()));
        boolean value = this.element.getInputBoolean();
        this.checkbox.setChecked(value);
    }

    @Override
    public void renderBg(GuiGraphics guiGraphics, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
        this.checkbox.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return this.checkbox.m_6375_(mouseX, mouseY, mouseButton) || super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean isRenderTooltip() {
        return this.renderTooltip;
    }

    @Override
    public void setRenderTooltip(boolean renderTooltip) {
        this.renderTooltip = renderTooltip;
    }

    protected void onChecked(boolean checked) {
        if (this.container instanceof IDirtyMarkListener) {
            ((IDirtyMarkListener)this.container).onDirty();
        }
        ((GuiElementValueTypeBoolean)this.getElement()).setInputBoolean(checked);
        this.sendValueToServer();
    }

    @Override
    public void sendValueToServer() {
        super.sendValueToServer();
        IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeBooleanValueChangedPacket(((GuiElementValueTypeBoolean)this.getElement()).getInputBoolean()));
    }

    @Override
    public GuiElementValueTypeBoolean<G, C> getElement() {
        return this.element;
    }

    public ButtonCheckbox getCheckbox() {
        return this.checkbox;
    }
}

