/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.block.cable.ICableFakeable;
import org.cyclops.integrateddynamics.api.network.IEnergyNetwork;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkCarrier;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkElementProvider;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.path.IPathElement;
import org.cyclops.integrateddynamics.capability.cable.CableFakeableConfig;
import org.cyclops.integrateddynamics.capability.network.EnergyNetworkConfig;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierConfig;
import org.cyclops.integrateddynamics.capability.network.PartNetworkConfig;
import org.cyclops.integrateddynamics.capability.network.PositionedAddonsNetworkIngredientsHandlerConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.path.PathElementConfig;
import org.cyclops.integrateddynamics.capability.path.SidedPathElement;
import org.cyclops.integrateddynamics.core.TickHandler;
import org.cyclops.integrateddynamics.core.network.Network;
import org.cyclops.integrateddynamics.core.persist.world.NetworkWorldStorage;

public class NetworkHelpers {
    public static LazyOptional<INetworkCarrier> getNetworkCarrier(BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return BlockEntityHelpers.getCapability((BlockGetter)world, (BlockPos)pos, (Direction)side, NetworkCarrierConfig.CAPABILITY);
    }

    public static LazyOptional<INetworkElementProvider> getNetworkElementProvider(BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return BlockEntityHelpers.getCapability((BlockGetter)world, (BlockPos)pos, (Direction)side, NetworkElementProviderConfig.CAPABILITY);
    }

    public static LazyOptional<INetwork> getNetwork(BlockGetter world, BlockPos pos, @Nullable Direction side) {
        LazyOptional networkCarried = NetworkHelpers.getNetworkCarrier(world, pos, side).lazyMap(carrier -> {
            INetwork network = carrier.getNetwork();
            return network != null ? LazyOptional.of(() -> network) : LazyOptional.empty();
        });
        return (LazyOptional)networkCarried.orElse((Object)LazyOptional.empty());
    }

    public static LazyOptional<INetwork> getNetwork(PartPos pos) {
        return NetworkHelpers.getNetwork((BlockGetter)pos.getPos().getLevel(true), pos.getPos().getBlockPos(), pos.getSide());
    }

    public static INetwork getNetworkChecked(BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return (INetwork)NetworkHelpers.getNetwork(world, pos, side).orElseThrow(() -> new IllegalStateException("Could not find a network container at " + pos.toString()));
    }

    public static INetwork getNetworkChecked(PartPos pos) {
        return (INetwork)NetworkHelpers.getNetwork(pos).orElseThrow(() -> new IllegalStateException("Could not find a network container at " + pos.toString()));
    }

    public static LazyOptional<IPartNetwork> getPartNetwork(LazyOptional<INetwork> optionalNetwork) {
        return optionalNetwork.map(network -> network.getCapability(PartNetworkConfig.CAPABILITY)).orElse(LazyOptional.empty());
    }

    public static LazyOptional<IPartNetwork> getPartNetwork(@Nullable INetwork network) {
        if (network == null) {
            return LazyOptional.empty();
        }
        return network.getCapability(PartNetworkConfig.CAPABILITY);
    }

    public static IPartNetwork getPartNetworkChecked(INetwork network) {
        return (IPartNetwork)network.getCapability(PartNetworkConfig.CAPABILITY).orElseThrow(() -> new IllegalStateException("Could not find a network's part network"));
    }

    public static LazyOptional<IEnergyNetwork> getEnergyNetwork(LazyOptional<INetwork> optionalNetwork) {
        return optionalNetwork.map(network -> network.getCapability(EnergyNetworkConfig.CAPABILITY)).orElse(LazyOptional.empty());
    }

    public static LazyOptional<IEnergyNetwork> getEnergyNetwork(@Nullable INetwork network) {
        if (network == null) {
            return LazyOptional.empty();
        }
        return network.getCapability(EnergyNetworkConfig.CAPABILITY);
    }

    public static IEnergyNetwork getEnergyNetworkChecked(INetwork network) {
        return (IEnergyNetwork)network.getCapability(EnergyNetworkConfig.CAPABILITY).orElseThrow(() -> new IllegalStateException("Could not find a network's energy network"));
    }

    public static <T, M> LazyOptional<IPositionedAddonsNetworkIngredients<T, M>> getIngredientNetwork(LazyOptional<INetwork> optionalNetwork, IngredientComponent<T, M> ingredientComponent) {
        return optionalNetwork.map(network -> ingredientComponent.getCapability(PositionedAddonsNetworkIngredientsHandlerConfig.CAPABILITY).map(handler -> handler.getStorage((INetwork)network)).orElse(LazyOptional.empty())).orElse(LazyOptional.empty());
    }

    public static Optional<INetwork> initNetwork(Level world, BlockPos pos, @Nullable Direction side) {
        return BlockEntityHelpers.getCapability((BlockGetter)world, (BlockPos)pos, (Direction)side, PathElementConfig.CAPABILITY).map(pathElement -> {
            Network network = Network.initiateNetworkSetup(SidedPathElement.of(pathElement, side));
            network.initialize();
            return Optional.of(network);
        }).orElse(Optional.empty());
    }

    public static void onElementProviderBlockNeighborChange(Level world, BlockPos pos, Block neighbourBlock, @Nullable Direction side, BlockPos neighbourBlockPos) {
        if (!world.m_5776_()) {
            NetworkHelpers.getNetwork((BlockGetter)world, pos, side).ifPresent(network -> NetworkHelpers.getNetworkElementProvider((BlockGetter)world, pos, side).ifPresent(networkElementProvider -> {
                for (INetworkElement networkElement : networkElementProvider.createNetworkElements(world, pos)) {
                    networkElement.onNeighborBlockChange((INetwork)network, (BlockGetter)world, neighbourBlock, neighbourBlockPos);
                }
            }));
        }
    }

    public static boolean shouldWork() {
        return !GeneralConfig.safeMode;
    }

    public static void invalidateNetworkElements(Level world, BlockPos pos, BlockEntity tile) {
        tile.getCapability(NetworkCarrierConfig.CAPABILITY, null).ifPresent(networkCarrier -> {
            INetwork network = networkCarrier.getNetwork();
            if (network != null) {
                tile.getCapability(NetworkElementProviderConfig.CAPABILITY, null).ifPresent(networkElementProvider -> {
                    for (INetworkElement networkElement : networkElementProvider.createNetworkElements(world, pos)) {
                        networkElement.invalidate(network);
                    }
                });
            }
        });
    }

    public static boolean revalidateNetworkElements(Level world, BlockPos pos) {
        INetworkCarrier networkCarrier = (INetworkCarrier)BlockEntityHelpers.getCapability((BlockGetter)world, (BlockPos)pos, NetworkCarrierConfig.CAPABILITY).orElse(null);
        IPathElement pathElement = (IPathElement)BlockEntityHelpers.getCapability((BlockGetter)world, (BlockPos)pos, PathElementConfig.CAPABILITY).orElse(null);
        if (TickHandler.getInstance().ticked && networkCarrier != null && pathElement != null && networkCarrier.getNetwork() == null && BlockEntityHelpers.getCapability((BlockGetter)world, (BlockPos)pos, CableFakeableConfig.CAPABILITY).map(ICableFakeable::isRealCable).orElse(true).booleanValue()) {
            return BlockEntityHelpers.getCapability((BlockGetter)world, (BlockPos)pos, NetworkElementProviderConfig.CAPABILITY).map(networkElementProvider -> {
                boolean foundNetwork = false;
                for (INetwork network : NetworkWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).getNetworks()) {
                    if (!network.containsSidedPathElement(SidedPathElement.of(pathElement, null))) continue;
                    for (INetworkElement networkElement : networkElementProvider.createNetworkElements(world, pos)) {
                        networkElement.revalidate(network);
                    }
                    foundNetwork = true;
                    break;
                }
                if (!foundNetwork && GeneralConfig.recreateCorruptedNetworks) {
                    IntegratedDynamics.clog(org.apache.logging.log4j.Level.WARN, String.format("Detected network position at position %s in world %s with corrupted network, recreating network...", pos, world.m_46472_().m_135782_()));
                    NetworkHelpers.initNetwork(world, pos, null);
                    return true;
                }
                return foundNetwork;
            }).orElse(false);
        }
        return false;
    }
}

