/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.blockentity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.cyclopscore.datastructure.DataSlotSupplied;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.network.IEnergyNetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.block.BlockCoalGenerator;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityCableConnectableInventory;
import org.cyclops.integrateddynamics.core.helper.EnergyHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.inventory.container.ContainerCoalGenerator;
import org.cyclops.integrateddynamics.network.CoalGeneratorNetworkElement;

public class BlockEntityCoalGenerator
extends BlockEntityCableConnectableInventory
implements IEnergyStorage,
MenuProvider {
    public static final int INVENTORY_SIZE = 1;
    public static final int MAX_PROGRESS = 13;
    public static final int ENERGY_PER_TICK = 20;
    public static final int SLOT_FUEL = 0;
    @NBTPersist
    private int currentlyBurningMax;
    @NBTPersist
    private int currentlyBurning;

    public BlockEntityCoalGenerator(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_COAL_GENERATOR, blockPos, blockState, 1, 64);
        this.addCapabilityInternal(NetworkElementProviderConfig.CAPABILITY, LazyOptional.of(() -> new NetworkElementProviderSingleton(){

            @Override
            public INetworkElement createNetworkElement(Level world, BlockPos blockPos) {
                return new CoalGeneratorNetworkElement(DimPos.of((Level)world, (BlockPos)blockPos));
            }
        }));
        this.addCapabilityInternal(ForgeCapabilities.ENERGY, LazyOptional.of(() -> this));
    }

    public LazyOptional<IEnergyNetwork> getEnergyNetwork() {
        return NetworkHelpers.getEnergyNetwork(this.getNetwork());
    }

    public void updateBlockState() {
        boolean wasBurning = (Boolean)this.m_58904_().m_8055_(this.m_58899_()).m_61143_((Property)BlockCoalGenerator.LIT);
        boolean isBurning = this.isBurning();
        if (isBurning != wasBurning) {
            this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58904_().m_8055_(this.m_58899_()).m_61124_((Property)BlockCoalGenerator.LIT, (Comparable)Boolean.valueOf(isBurning)));
        }
    }

    public int getProgress() {
        float current = this.currentlyBurning;
        float max = this.currentlyBurningMax;
        if (max == 0.0f) {
            return -1;
        }
        return Math.round(current / max * 13.0f);
    }

    public boolean isBurning() {
        return this.currentlyBurning < this.currentlyBurningMax;
    }

    public boolean canAddEnergy(int energy) {
        IEnergyNetwork network = (IEnergyNetwork)this.getEnergyNetwork().orElse(null);
        if (network != null && (Long)network.getChannel(0).insert((Object)energy, true) == 0L) {
            return true;
        }
        return this.addEnergyFe(energy, true) == energy;
    }

    protected int addEnergy(int energy) {
        IEnergyNetwork network = (IEnergyNetwork)this.getEnergyNetwork().orElse(null);
        int toFill = energy;
        if (network != null) {
            toFill = Helpers.castSafe((long)((Long)network.getChannel(0).insert((Object)toFill, false)));
        }
        if (toFill > 0) {
            toFill -= this.addEnergyFe(toFill, false);
        }
        return energy - toFill;
    }

    protected int addEnergyFe(int energy, boolean simulate) {
        return EnergyHelpers.fillNeigbours(this.m_58904_(), this.m_58899_(), energy, simulate);
    }

    public static int getFuelTime(ItemStack itemStack) {
        return ForgeHooks.getBurnTime((ItemStack)itemStack, (RecipeType)RecipeType.f_44108_);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return 0;
    }

    public int getMaxEnergyStored() {
        return 0;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return false;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.integrateddynamics.coal_generator");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerCoalGenerator(id, playerInventory, (Container)this.getInventory(), (DataSlot)new DataSlotSupplied(this::getProgress));
    }

    public static class Ticker
    extends BlockEntityCableConnectableInventory.Ticker<BlockEntityCoalGenerator> {
        @Override
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityCoalGenerator blockEntity) {
            super.update(level, pos, blockState, blockEntity);
            if ((!blockEntity.getInventory().m_8020_(0).m_41619_() || blockEntity.isBurning()) && blockEntity.canAddEnergy(20)) {
                if (blockEntity.isBurning()) {
                    if (blockEntity.currentlyBurning++ >= blockEntity.currentlyBurningMax) {
                        blockEntity.currentlyBurning = 0;
                        blockEntity.currentlyBurningMax = 0;
                    }
                    int toFill = 20;
                    blockEntity.addEnergy(toFill);
                    blockEntity.m_6596_();
                }
                if (!blockEntity.isBurning()) {
                    ItemStack fuel;
                    if (BlockEntityCoalGenerator.getFuelTime(blockEntity.getInventory().m_8020_(0)) > 0 && !(fuel = blockEntity.getInventory().m_7407_(0, 1)).m_41619_()) {
                        if (blockEntity.getInventory().m_8020_(0).m_41619_()) {
                            blockEntity.getInventory().m_6836_(0, fuel.m_41720_().getCraftingRemainingItem(fuel));
                        }
                        blockEntity.currentlyBurningMax = BlockEntityCoalGenerator.getFuelTime(fuel);
                        blockEntity.currentlyBurning = 0;
                        blockEntity.m_6596_();
                    }
                    blockEntity.updateBlockState();
                }
            }
        }
    }
}

