/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.level;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.OptionalDouble;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.core.helper.WrenchHelpers;
import org.cyclops.integrateddynamics.core.network.PartOffsetsClientNotifier;
import org.cyclops.integrateddynamics.network.packet.PartOffsetsSubscribePacket;

public class PartOffsetsOverlayRenderer {
    public static final RenderType RENDER_TYPE_LINE = RenderType.m_173215_((String)"integrateddynamicsline", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.DEBUG_LINES, (int)128, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderType.f_173095_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(1.0))).m_110669_(RenderStateShard.f_110119_).m_110685_(RenderStateShard.f_110139_).m_110687_(new RenderStateShard.WriteMaskStateShard(true, false)).m_110691_(false));
    private static final PartOffsetsOverlayRenderer _INSTANCE = new PartOffsetsOverlayRenderer();
    private boolean subscribedToServerChanges = false;
    private List<PartOffsetsClientNotifier.Entry> data = Lists.newArrayList();

    private PartOffsetsOverlayRenderer() {
    }

    public static PartOffsetsOverlayRenderer getInstance() {
        return _INSTANCE;
    }

    private void subscribeToServerChanges() {
        IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new PartOffsetsSubscribePacket(true));
        this.subscribedToServerChanges = true;
    }

    private void unsubscribeToServerChanges() {
        IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new PartOffsetsSubscribePacket(false));
        this.subscribedToServerChanges = false;
    }

    public void clear() {
        this.data.clear();
    }

    public void setData(List<PartOffsetsClientNotifier.Entry> data) {
        this.data = data;
    }

    @SubscribeEvent
    public void onRender(RenderLevelStageEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            if (player.m_21120_(InteractionHand.MAIN_HAND).m_204117_(WrenchHelpers.TAG_WRENCH) || player.m_21120_(InteractionHand.OFF_HAND).m_204117_(WrenchHelpers.TAG_WRENCH)) {
                if (!this.subscribedToServerChanges) {
                    this.subscribeToServerChanges();
                }
                Vec3 eyePos = event.getCamera().m_90583_();
                for (PartOffsetsClientNotifier.Entry entry : this.data) {
                    this.renderOffset(event.getPoseStack(), (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110109_(), entry, eyePos);
                }
            } else if (this.subscribedToServerChanges) {
                this.data.clear();
                this.unsubscribeToServerChanges();
            }
        }
    }

    private void renderOffset(PoseStack matrixStack, MultiBufferSource renderTypeBuffer, PartOffsetsClientNotifier.Entry entry, Vec3 eyePos) {
        double offsetX = eyePos.f_82479_;
        double offsetY = eyePos.f_82480_;
        double offsetZ = eyePos.f_82481_;
        Random posRand = new Random(entry.source().m_121878_());
        float r = 0.5f + posRand.nextFloat() / 2.0f;
        float g = 0.5f + posRand.nextFloat() / 2.0f;
        float b = 0.5f + posRand.nextFloat() / 2.0f;
        float a = 0.9f;
        VertexConsumer vb = renderTypeBuffer.m_6299_(RENDER_TYPE_LINE);
        float minX = (float)entry.source().m_123341_() - (float)offsetX + 0.5f + (float)entry.sourceSide().m_122429_() * 0.5f;
        float minY = (float)entry.source().m_123342_() - (float)offsetY + 0.5f + (float)entry.sourceSide().m_122430_() * 0.5f;
        float minZ = (float)entry.source().m_123343_() - (float)offsetZ + 0.5f + (float)entry.sourceSide().m_122431_() * 0.5f;
        float maxX = (float)entry.source().m_123341_() - (float)offsetX + 0.5f + (float)entry.targetOffset().m_123341_() + (entry.targetSide().m_122434_() != entry.sourceSide().m_122434_() ? (float)entry.targetSide().m_122429_() * 0.5f : 0.0f);
        float maxY = (float)entry.source().m_123342_() - (float)offsetY + 0.5f + (float)entry.targetOffset().m_123342_() + (entry.targetSide().m_122434_() != entry.sourceSide().m_122434_() ? (float)entry.targetSide().m_122430_() * 0.5f : 0.0f);
        float maxZ = (float)entry.source().m_123343_() - (float)offsetZ + 0.5f + (float)entry.targetOffset().m_123343_() + (entry.targetSide().m_122434_() != entry.sourceSide().m_122434_() ? (float)entry.targetSide().m_122431_() * 0.5f : 0.0f);
        vb.m_252986_(matrixStack.m_85850_().m_252922_(), minX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
        vb.m_252986_(matrixStack.m_85850_().m_252922_(), maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
        AABB bb = new AABB(entry.targetSide().m_122429_() == 1 ? 0.9 : 0.0, entry.targetSide().m_122430_() == 1 ? 0.9 : 0.0, entry.targetSide().m_122431_() == 1 ? 0.9 : 0.0, entry.targetSide().m_122429_() == -1 ? 0.1 : 1.0, entry.targetSide().m_122430_() == -1 ? 0.1 : 1.0, entry.targetSide().m_122431_() == -1 ? 0.1 : 1.0);
        bb = bb.m_82338_(entry.source()).m_82386_((double)entry.targetOffset().m_123341_(), (double)entry.targetOffset().m_123342_(), (double)entry.targetOffset().m_123343_()).m_82386_(-offsetX, -offsetY, -offsetZ).m_82377_(0.05, 0.05, 0.05).m_82377_(-0.05, -0.05, -0.05);
        LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)renderTypeBuffer.m_6299_(RenderType.m_110504_()), (AABB)bb, (float)r, (float)g, (float)b, (float)a);
    }
}

