/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.capability.cable.CableConfig;
import org.cyclops.integrateddynamics.capability.cable.CableTile;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierConfig;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierDefault;
import org.cyclops.integrateddynamics.capability.path.PathElementConfig;
import org.cyclops.integrateddynamics.capability.path.PathElementTile;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;

public class BlockEntityCableConnectable
extends CyclopsBlockEntity {
    @NBTPersist
    private EnumFacingMap<Boolean> connected = EnumFacingMap.newMap();
    private final ICable cable = new CableTile<BlockEntityCableConnectable>(this){

        @Override
        protected boolean isForceDisconnectable() {
            return false;
        }

        @Override
        protected EnumFacingMap<Boolean> getForceDisconnected() {
            return null;
        }

        @Override
        protected EnumFacingMap<Boolean> getConnected() {
            return ((BlockEntityCableConnectable)this.tile).connected;
        }
    };

    public BlockEntityCableConnectable(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
        this.addCapabilityInternal(CableConfig.CAPABILITY, LazyOptional.of(() -> this.cable));
        this.addCapabilityInternal(NetworkCarrierConfig.CAPABILITY, LazyOptional.of(NetworkCarrierDefault::new));
        this.addCapabilityInternal(PathElementConfig.CAPABILITY, LazyOptional.of(() -> new PathElementTile<BlockEntityCableConnectable>(this, this.cable)));
    }

    public EnumFacingMap<Boolean> getConnected() {
        return this.connected;
    }

    public ICable getCable() {
        return this.cable;
    }

    public void read(CompoundTag tag) {
        super.read(tag);
        this.connected.clear();
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.m_58904_() != null && !this.m_58904_().f_46443_) {
            NetworkHelpers.invalidateNetworkElements(this.m_58904_(), this.m_58899_(), (BlockEntity)this);
        }
    }

    public static class Ticker<T extends BlockEntityCableConnectable>
    extends BlockEntityTickerDelayed<T> {
        protected void update(Level level, BlockPos pos, BlockState blockState, T blockEntity) {
            super.update(level, pos, blockState, blockEntity);
            if (((BlockEntityCableConnectable)((Object)blockEntity)).getConnected().isEmpty()) {
                ((BlockEntityCableConnectable)((Object)blockEntity)).getCable().updateConnections();
            }
            NetworkHelpers.revalidateNetworkElements(level, pos);
        }
    }
}

