/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartPosIteratorHandler;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetwork;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PrioritizedPartPos;

public abstract class PositionedAddonsNetwork
implements IPositionedAddonsNetwork {
    private INetwork network;
    private final Set<PrioritizedPartPos> allPositions = Sets.newTreeSet();
    private final Int2ObjectMap<Set<PrioritizedPartPos>> positions = new Int2ObjectOpenHashMap();
    private final Map<PartPos, Integer> positionChannels = Maps.newHashMap();
    private final Set<Pair<Long, PartPos>> disabledPositions = Sets.newHashSet();
    private IPartPosIteratorHandler partPosIteratorHandler = null;

    @Override
    public int[] getChannels() {
        return this.positions.keySet().toIntArray();
    }

    @Override
    public boolean hasPositions() {
        return !this.positions.isEmpty();
    }

    @Override
    public Collection<PrioritizedPartPos> getPrioritizedPositions(int channel) {
        if (channel == -1) {
            return this.getPrioritizedPositions();
        }
        Set<PrioritizedPartPos> positions = (Set<PrioritizedPartPos>)this.positions.get(channel);
        Set wildcardPositions = (Set)this.positions.get(-1);
        if (positions == null) {
            if (wildcardPositions != null) {
                return wildcardPositions;
            }
            positions = Collections.emptySet();
        }
        if (wildcardPositions == null) {
            return positions;
        }
        TreeSet merged = Sets.newTreeSet();
        merged.addAll(positions);
        merged.addAll(wildcardPositions);
        return merged;
    }

    @Override
    public Collection<PrioritizedPartPos> getPrioritizedPositions() {
        return this.allPositions;
    }

    @Override
    public int getPositionChannel(PartPos pos) {
        return this.positionChannels.getOrDefault(pos, -1);
    }

    protected void invalidateIterators() {
        this.setPartPosIteratorHandler(null);
    }

    @Override
    public void setPartPosIteratorHandler(@Nullable IPartPosIteratorHandler iteratorHandler) {
        this.partPosIteratorHandler = iteratorHandler;
    }

    @Override
    @Nullable
    public IPartPosIteratorHandler getPartPosIteratorHandler() {
        if (this.partPosIteratorHandler != null) {
            return this.partPosIteratorHandler;
        }
        return null;
    }

    @Override
    public boolean addPosition(PartPos pos, int priority, int channel) {
        this.invalidateIterators();
        PrioritizedPartPos prioritizedPosition = PrioritizedPartPos.of(pos, priority);
        if (this.allPositions.add(prioritizedPosition)) {
            Set positions = (Set)this.positions.get(channel);
            if (positions == null) {
                positions = Sets.newTreeSet();
                this.positions.put(channel, (Object)positions);
            }
            positions.add(prioritizedPosition);
            this.positionChannels.put(pos, channel);
            this.onPositionAdded(channel, prioritizedPosition);
            return true;
        }
        return false;
    }

    protected void onPositionAdded(int channel, PrioritizedPartPos pos) {
    }

    @Override
    public void removePosition(PartPos pos) {
        this.invalidateIterators();
        Wrapper removedChannel = new Wrapper((Object)-2);
        Wrapper removedPos = new Wrapper(null);
        block0: for (Int2ObjectMap.Entry entry : this.positions.int2ObjectEntrySet()) {
            int channel = entry.getIntKey();
            Set positions = (Set)entry.getValue();
            Iterator it = positions.iterator();
            while (it.hasNext()) {
                PrioritizedPartPos prioritizedPartPos = (PrioritizedPartPos)it.next();
                if (!prioritizedPartPos.getPartPos().equals(pos)) continue;
                it.remove();
                this.allPositions.remove(prioritizedPartPos);
                removedPos.set((Object)prioritizedPartPos);
                removedChannel.set((Object)channel);
                continue block0;
            }
        }
        int channel = (Integer)removedChannel.get();
        if (channel != -2) {
            this.onPositionRemoved(channel, (PrioritizedPartPos)removedPos.get());
            if (((Set)this.positions.get(channel)).isEmpty()) {
                this.positions.remove(channel);
            }
        }
        this.positionChannels.remove(pos);
    }

    protected void onPositionRemoved(int channel, PrioritizedPartPos pos) {
    }

    @Override
    public boolean isPositionDisabled(PartPos pos) {
        return this.disabledPositions.contains(Pair.of((Object)Thread.currentThread().getId(), (Object)pos));
    }

    @Override
    public void disablePosition(PartPos pos) {
        this.disabledPositions.add((Pair<Long, PartPos>)Pair.of((Object)Thread.currentThread().getId(), (Object)pos));
    }

    @Override
    public void enablePosition(PartPos pos) {
        this.disabledPositions.remove(Pair.of((Object)Thread.currentThread().getId(), (Object)pos));
    }

    public INetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(INetwork network) {
        this.network = network;
    }
}

