/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network.diagnostics;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.cyclops.integrateddynamics.core.network.diagnostics.IRawData;

public class RawObserverData
implements IRawData {
    private final ResourceKey<Level> dimension;
    private final BlockPos pos;
    private final Direction side;
    private final String name;
    private final long last20TicksDurationNs;

    public String toString() {
        return String.format("%s: %s,%s,%s,%s (%s)", this.name, this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_(), this.side, this.dimension.m_135782_());
    }

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("dimension", this.dimension.m_135782_().toString());
        tag.m_128356_("pos", this.pos.m_121878_());
        if (this.side != null) {
            tag.m_128405_("side", this.side.ordinal());
        }
        tag.m_128359_("name", this.name);
        tag.m_128356_("last20TicksDurationNs", this.last20TicksDurationNs);
        return tag;
    }

    public static RawObserverData fromNbt(CompoundTag tag) {
        return new RawObserverData((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_("dimension"))), BlockPos.m_122022_((long)tag.m_128454_("pos")), tag.m_128441_("side") ? Direction.values()[tag.m_128451_("side")] : null, tag.m_128461_("name"), tag.m_128454_("last20TicksDurationNs"));
    }

    public RawObserverData(ResourceKey<Level> dimension, BlockPos pos, Direction side, String name, long last20TicksDurationNs) {
        this.dimension = dimension;
        this.pos = pos;
        this.side = side;
        this.name = name;
        this.last20TicksDurationNs = last20TicksDurationNs;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Direction getSide() {
        return this.side;
    }

    public String getName() {
        return this.name;
    }

    public long getLast20TicksDurationNs() {
        return this.last20TicksDurationNs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawObserverData)) {
            return false;
        }
        RawObserverData other = (RawObserverData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLast20TicksDurationNs() != other.getLast20TicksDurationNs()) {
            return false;
        }
        ResourceKey<Level> this$dimension = this.getDimension();
        ResourceKey<Level> other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) {
            return false;
        }
        BlockPos this$pos = this.getPos();
        BlockPos other$pos = other.getPos();
        if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
            return false;
        }
        Direction this$side = this.getSide();
        Direction other$side = other.getSide();
        if (this$side == null ? other$side != null : !this$side.equals(other$side)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RawObserverData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $last20TicksDurationNs = this.getLast20TicksDurationNs();
        result = result * 59 + (int)($last20TicksDurationNs >>> 32 ^ $last20TicksDurationNs);
        ResourceKey<Level> $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : $dimension.hashCode());
        BlockPos $pos = this.getPos();
        result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
        Direction $side = this.getSide();
        result = result * 59 + ($side == null ? 43 : $side.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }
}

