/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.metadata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.metadata.IRegistryExportable;
import org.cyclops.cyclopscore.metadata.RegistryExportableRecipeAbstract;
import org.cyclops.cyclopscore.recipe.type.IInventoryFluid;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeDryingBasin;

public class RegistryExportableDryingBasinRecipe
extends RegistryExportableRecipeAbstract<RecipeType<RecipeDryingBasin>, RecipeDryingBasin, IInventoryFluid> {
    protected RegistryExportableDryingBasinRecipe() {
        super(() -> RegistryEntries.RECIPETYPE_DRYING_BASIN);
    }

    public static JsonObject serializeRecipeStatic(RecipeDryingBasin recipe) {
        JsonObject object = new JsonObject();
        int duration = recipe.getDuration();
        object.addProperty("duration", (Number)duration);
        JsonObject inputObject = new JsonObject();
        ItemStack[] inputItems = recipe.getInputIngredient().m_43908_();
        JsonArray arrayInputs = new JsonArray();
        for (ItemStack input : inputItems) {
            arrayInputs.add((JsonElement)IRegistryExportable.serializeItemStack((ItemStack)input));
        }
        inputObject.add("item", (JsonElement)arrayInputs);
        FluidStack inputFluid = recipe.getInputFluid();
        if (inputFluid != null) {
            inputObject.add("fluid", (JsonElement)IRegistryExportable.serializeFluidStack((FluidStack)inputFluid));
        }
        JsonObject outputObject = new JsonObject();
        FluidStack fluidOutput = recipe.getOutputFluid();
        if (fluidOutput != null) {
            outputObject.add("fluid", (JsonElement)IRegistryExportable.serializeFluidStack((FluidStack)fluidOutput));
        }
        ItemStack itemOutput = recipe.getOutputItemFirst();
        outputObject.add("item", (JsonElement)IRegistryExportable.serializeItemStack((ItemStack)itemOutput));
        object.add("input", (JsonElement)inputObject);
        object.add("output", (JsonElement)outputObject);
        return object;
    }

    public JsonObject serializeRecipe(RecipeDryingBasin recipe) {
        return RegistryExportableDryingBasinRecipe.serializeRecipeStatic(recipe);
    }
}

