/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.network.IFullNetworkListener;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.network.PartOffsetsClientNotifier;
import org.cyclops.integrateddynamics.core.network.diagnostics.NetworkDiagnostics;
import org.cyclops.integrateddynamics.core.persist.world.NetworkWorldStorage;

public final class TickHandler {
    private static TickHandler INSTANCE;
    private int tick = 0;
    private boolean shouldCrash = false;
    public boolean ticked = false;

    private TickHandler() {
    }

    public static TickHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TickHandler();
        }
        return INSTANCE;
    }

    public void setShouldCrash() {
        this.shouldCrash = true;
    }

    @SubscribeEvent
    public void onTick(ServerTickEvent.Post event) {
        if (this.shouldCrash) {
            throw new RuntimeException("Forcefully crashed the server.");
        }
        for (INetwork network : ((NetworkWorldStorage)NetworkWorldStorage.Access.getInstance(IntegratedDynamics._instance).get()).getNetworks()) {
            network.updateGuaranteed();
        }
        if (NetworkHelpers.shouldWork()) {
            boolean isBeingDiagnozed = NetworkDiagnostics.getInstance().isBeingDiagnozed();
            if (isBeingDiagnozed) {
                this.tick = (this.tick + 1) % IModHelpers.get().getMinecraftHelpers().getSecondInTicks();
            }
            boolean shouldSendTickDurationInfo = isBeingDiagnozed && this.tick == 0;
            for (INetwork network : ((NetworkWorldStorage)NetworkWorldStorage.Access.getInstance(IntegratedDynamics._instance).get()).getNetworks()) {
                if (isBeingDiagnozed && (shouldSendTickDurationInfo || network.hasChanged())) {
                    NetworkDiagnostics.getInstance().sendNetworkUpdate(network);
                    network.resetLastSecondDurations();
                    for (IFullNetworkListener fullNetworkListener : network.getFullNetworkListeners()) {
                        if (!(fullNetworkListener instanceof IPositionedAddonsNetworkIngredients)) continue;
                        IPositionedAddonsNetworkIngredients networkIngredients = (IPositionedAddonsNetworkIngredients)((Object)fullNetworkListener);
                        networkIngredients.resetLastSecondDurationsIndex();
                    }
                }
                try {
                    if (network.isCrashed()) continue;
                    network.update();
                }
                catch (Throwable e) {
                    network.setCrashed(true);
                    throw e;
                }
            }
        }
        this.ticked = true;
        PartOffsetsClientNotifier.getInstance().tick();
    }
}

