/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui;

import com.google.common.collect.Lists;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.item.DamageIndicatedItemComponent;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMechanicalMachine;

public abstract class ContainerScreenMechanicalMachine<C extends ContainerMechanicalMachine<?>>
extends ContainerScreenExtended<C> {
    public ContainerScreenMechanicalMachine(C container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
    }

    public void drawEnergyBarTooltip(GuiGraphics guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY) {
        IModHelpers.get().getGuiHelpers().renderTooltipOptional((AbstractContainerScreen)this, guiGraphics, 8, 16, 18, 60, mouseX, mouseY, () -> {
            int energyStored = ((ContainerMechanicalMachine)this.getMenu()).getEnergy();
            int energyMax = ((ContainerMechanicalMachine)this.getMenu()).getMaxEnergy();
            if (energyMax > 0) {
                return Optional.of(Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"general.integrateddynamics.energy"), Helpers.getLocalizedEnergyLevel(energyStored, energyMax)}));
            }
            return Optional.empty();
        });
    }

    public void drawFluidTankTooltip(GuiGraphics guiGraphics, FluidStack fluidStack, int fluidCapacity, int x, int y, int width, int height, int mouseX, int mouseY) {
        IModHelpers.get().getGuiHelpers().renderTooltipOptional((AbstractContainerScreen)this, guiGraphics, x, y, width, height, mouseX, mouseY, () -> {
            if (fluidStack != null && !fluidStack.isEmpty()) {
                Component fluidName = fluidStack.getHoverName();
                return Optional.of(Lists.newArrayList((Object[])new Component[]{fluidName, DamageIndicatedItemComponent.getInfo((FluidStack)fluidStack, (int)fluidStack.getAmount(), (int)fluidCapacity)}));
            }
            return Optional.empty();
        });
    }

    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, ARGB.opaque((int)0x404040), false);
    }
}

