/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui.container;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.StringHelpers;

public class DisplayErrorsComponent {
    public void drawForeground(GuiGraphics guiGraphics, @Nullable List<Component> errors, int errorX, int errorY, int mouseX, int mouseY, ContainerScreenExtended<?> gui, int guiLeft, int guiTop) {
        if (errors != null && !errors.isEmpty() && gui.isHovering(errorX, errorY, Images.ERROR.getSheetWidth(), Images.ERROR.getSheetHeight(), (double)mouseX, (double)mouseY)) {
            LinkedList lines = Lists.newLinkedList();
            for (Component error : errors) {
                lines.addAll(StringHelpers.splitLines((String)error.getString(), (int)IModHelpers.get().getL10NHelpers().getMaxTooltipLineLength(), (String)ChatFormatting.RED.toString()).stream().map(Component::literal).collect(Collectors.toList()));
            }
            gui.drawTooltip((List)lines, guiGraphics, mouseX, mouseY);
        }
    }

    public void drawBackground(GuiGraphics guiGraphics, @Nullable List<Component> errors, int errorX, int errorY, int okX, int okY, ContainerScreenExtended<?> gui, int guiLeft, int guiTop, boolean okCondition) {
        if (errors != null && !errors.isEmpty()) {
            Images.ERROR.draw(guiGraphics, guiLeft + errorX, guiTop + errorY);
        } else if (okCondition) {
            Images.OK.draw(guiGraphics, guiLeft + okX, guiTop + okY);
        }
    }
}

