/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable.gui;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.StringHelpers;
import org.cyclops.integrateddynamics.api.client.gui.subgui.IGuiInputElement;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGuiBox;
import org.cyclops.integrateddynamics.core.client.gui.subgui.SubGuiBox;

public abstract class SubGuiValueTypeInfoBase<S extends ISubGuiBox, G extends ContainerScreenExtended<?>, C extends AbstractContainerMenu>
extends SubGuiBox.Base {
    private final IGuiInputElement element;
    protected final G gui;
    protected final C container;

    public SubGuiValueTypeInfoBase(G gui, C container, IGuiInputElement<S, G, C, ?> element, int x, int y, int width, int height) {
        super(SubGuiBox.Box.DARK, x, y, width, height);
        this.gui = gui;
        this.container = container;
        this.element = element;
    }

    protected abstract boolean showError();

    protected abstract Component getLastError();

    protected abstract ResourceLocation getTexture();

    protected int getSignalX() {
        return this.getWidth() - 22;
    }

    protected int getSignalY() {
        return (this.getHeight() - 12) / 2;
    }

    @Override
    public void renderBg(GuiGraphics guiGraphics, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
        int x = guiLeft + this.getX();
        int y = guiTop + this.getY();
        if (this.shouldRenderElementName()) {
            guiGraphics.drawString(fontRenderer, this.element.getName(), x + 2, y + 6, IModHelpers.get().getBaseHelpers().RGBAToInt(240, 240, 240, 255), true);
        }
        if (this.showError()) {
            Component lastError = this.getLastError();
            if (lastError != null) {
                Images.ERROR.draw(guiGraphics, x + this.getSignalX(), y + this.getSignalY() - 1);
            } else {
                Images.OK.draw(guiGraphics, x + this.getSignalX(), y + this.getSignalY() + 1);
            }
        }
    }

    public boolean shouldRenderElementName() {
        return true;
    }

    @Override
    public void drawGuiContainerForegroundLayer(GuiGraphics guiGraphics, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, int mouseX, int mouseY) {
        Component lastError;
        super.drawGuiContainerForegroundLayer(guiGraphics, guiLeft, guiTop, textureManager, fontRenderer, mouseX, mouseY);
        int x = this.getX();
        int y = this.getY();
        if (this.showError() && (lastError = this.getLastError()) != null && this.gui.isHovering(x + this.getSignalX(), y + this.getSignalY() - 1, Images.ERROR.getSheetWidth(), Images.ERROR.getSheetHeight(), (double)mouseX, (double)mouseY)) {
            List lines = StringHelpers.splitLines((String)lastError.getString(), (int)IModHelpers.get().getL10NHelpers().getMaxTooltipLineLength(), (String)ChatFormatting.RED.toString()).stream().map(Component::literal).collect(Collectors.toList());
            this.gui.drawTooltip(lines, guiGraphics, mouseX, mouseY);
        }
    }
}

