/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.path;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.path.IPathElement;
import org.cyclops.integrateddynamics.api.path.ISidedPathElement;
import org.cyclops.integrateddynamics.api.path.SidedPathElementParams;
import org.cyclops.integrateddynamics.capability.path.SidedPathElement;

public class Cluster
implements Collection<ISidedPathElement> {
    private final Set<ISidedPathElement> elements;

    public Cluster() {
        this.elements = Sets.newTreeSet();
    }

    public Cluster(TreeSet<ISidedPathElement> elements) {
        this.elements = elements;
    }

    public void fromParams(List<SidedPathElementParams> pathElements) {
        for (SidedPathElementParams pathElementParam : pathElements) {
            ResourceLocation dimensionId = ResourceLocation.parse((String)pathElementParam.dimension());
            ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimensionId);
            ServerLevel world = ServerLifecycleHooks.getCurrentServer().getLevel(dimension);
            BlockPos pos = pathElementParam.pos();
            Direction side = pathElementParam.side().orElse(null);
            if (world == null) {
                IntegratedDynamics.clog(Level.WARN, String.format("Skipped loading part from a network at the invalid dimension id %s.", dimensionId));
                continue;
            }
            IPathElement pathElement = IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)world, pos, (Object)side, Capabilities.PathElement.BLOCK).orElse(null);
            if (pathElement == null) {
                IntegratedDynamics.clog(Level.WARN, String.format("Skipped loading part from a network at position %s in world %s because it has no valid path element.", pos, dimensionId));
                continue;
            }
            this.elements.add(SidedPathElement.of(pathElement, side));
        }
    }

    public List<SidedPathElementParams> toParams() {
        ArrayList list = Lists.newArrayList();
        for (ISidedPathElement e : this.elements) {
            list.add(e.getParams());
        }
        return list;
    }

    public Set<ISidedPathElement> getElements() {
        return this.elements;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<ISidedPathElement> this$elements = this.getElements();
        Set<ISidedPathElement> other$elements = other.getElements();
        return !(this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Cluster;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<ISidedPathElement> $elements = this.getElements();
        result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
        return result;
    }

    public String toString() {
        return "Cluster(elements=" + String.valueOf(this.getElements()) + ")";
    }

    @Override
    public int size() {
        return this.getElements().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getElements().isEmpty();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.getElements().contains(arg0);
    }

    @Override
    public Iterator<ISidedPathElement> iterator() {
        return this.getElements().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getElements().toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.getElements().toArray(arg0);
    }

    @Override
    public boolean add(ISidedPathElement arg0) {
        return this.getElements().add(arg0);
    }

    @Override
    public boolean remove(Object arg0) {
        return this.getElements().remove(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.getElements().containsAll(arg0);
    }

    @Override
    public boolean addAll(Collection<? extends ISidedPathElement> arg0) {
        return this.getElements().addAll(arg0);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return this.getElements().retainAll(arg0);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        return this.getElements().removeAll(arg0);
    }

    @Override
    public void clear() {
        this.getElements().clear();
    }

    @Override
    public Spliterator<ISidedPathElement> spliterator() {
        return this.getElements().spliterator();
    }

    @Override
    public <T> T[] toArray(IntFunction<T[]> generator) {
        return this.getElements().toArray(generator);
    }

    @Override
    public boolean removeIf(Predicate<? super ISidedPathElement> filter) {
        return this.getElements().removeIf(filter);
    }

    @Override
    public Stream<ISidedPathElement> stream() {
        return this.getElements().stream();
    }

    @Override
    public Stream<ISidedPathElement> parallelStream() {
        return this.getElements().parallelStream();
    }

    @Override
    public void forEach(Consumer<? super ISidedPathElement> action) {
        this.getElements().forEach(action);
    }
}

