/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.persist.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.world.level.saveddata.SavedDataType;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;
import org.cyclops.cyclopscore.persist.world.WorldStorage;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.core.TickHandler;
import org.cyclops.integrateddynamics.core.network.Network;
import org.cyclops.integrateddynamics.core.network.NetworkParams;

public class NetworkWorldStorage
extends WorldStorage<NetworkWorldStorage> {
    private final List<NetworkParams> networkParams;
    private Set<Network> networks = Sets.newHashSet();

    public NetworkWorldStorage(List<NetworkParams> networkParams) {
        this.networkParams = Lists.newArrayList(networkParams);
    }

    public synchronized void addNewNetwork(Network network) {
        this.networks.add(network);
        this.setDirty();
    }

    public synchronized void removeInvalidatedNetwork(Network network) {
        this.networks.remove(network);
        this.setDirty();
    }

    public synchronized Set<INetwork> getNetworks() {
        return Collections.unmodifiableSet(Sets.newHashSet(this.networks));
    }

    public void afterLoad() {
        for (NetworkParams networkParams : this.networkParams) {
            Network network = new Network();
            network.fromParams(networkParams);
            this.networks.add(network);
        }
        TickHandler.getInstance().ticked = false;
        for (INetwork iNetwork : this.networks) {
            iNetwork.afterServerLoad();
        }
    }

    public void beforeSave() {
        for (Network network : this.networks) {
            network.beforeServerStop();
        }
        for (Network network : this.networks) {
            this.networkParams.add(network.toParams());
        }
        this.setDirty();
    }

    public static class Access
    extends WorldStorage.Access<NetworkWorldStorage> {
        private static Access INSTANCE = null;

        public static Access getInstance(ModBaseNeoForge<?> mod) {
            if (INSTANCE == null) {
                INSTANCE = new Access(mod);
            }
            return INSTANCE;
        }

        public Access(ModBaseNeoForge<?> mod) {
            super(new SavedDataType(mod.getModId() + "_networks", ctx -> new NetworkWorldStorage(Lists.newArrayList()), ctx -> RecordCodecBuilder.create(instance -> instance.group((App)RecordCodecBuilder.point((Object)ctx.levelOrThrow()), (App)Codec.list(NetworkParams.CODEC).fieldOf("networks").forGetter(data -> data.networkParams)).apply((Applicative)instance, (level, networkParams) -> new NetworkWorldStorage((List<NetworkParams>)networkParams)))), mod);
        }
    }
}

