/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.block.BlockMechanicalSqueezer;
import org.cyclops.integrateddynamics.core.recipe.display.RecipeDisplaySqueezer;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;

public class RecipeMechanicalSqueezer
extends RecipeSqueezer {
    private final int duration;

    public RecipeMechanicalSqueezer(Ingredient inputIngredient, NonNullList<RecipeSqueezer.IngredientChance> outputItems, Optional<FluidStack> outputFluid, int duration) {
        super(inputIngredient, outputItems, outputFluid);
        this.duration = duration;
    }

    public int getDuration() {
        return this.duration;
    }

    @Override
    public RecipeSerializer<? extends Recipe<CraftingInput>> getSerializer() {
        return (RecipeSerializer)RegistryEntries.RECIPESERIALIZER_MECHANICAL_SQUEEZER.get();
    }

    @Override
    public RecipeType<? extends Recipe<CraftingInput>> getType() {
        return (RecipeType)RegistryEntries.RECIPETYPE_MECHANICAL_SQUEEZER.get();
    }

    @Override
    public RecipeBookCategory recipeBookCategory() {
        return (RecipeBookCategory)RegistryEntries.RECIPEBOOKCATEGORY_MECHANICAL_SQUEEZER.get();
    }

    @Override
    public List<RecipeDisplay> display() {
        return List.of(new RecipeDisplaySqueezer(this.getInputIngredient().display(), this.getOutputItemsAsSlots(), this.getOutputFluid().orElse(FluidStack.EMPTY), (SlotDisplay)new SlotDisplay.ItemSlotDisplay(((BlockMechanicalSqueezer)((Object)RegistryEntries.BLOCK_MECHANICAL_SQUEEZER.get())).asItem()), this.getDuration()));
    }
}

