/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.test;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.http.util.Asserts;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.command.CommandTest;

public class TestHelpers {
    public static boolean canRunIntegrationTests() {
        try {
            Class.forName(CommandTest.CLASSES.get(0));
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static <T> void assertEqual(T actual, T expected, String ifEqual) {
        try {
            if (actual instanceof Double) {
                Asserts.check(((Double)actual - (Double)expected < 1.0E-4 ? 1 : 0) != 0, (String)ifEqual);
            } else if (actual instanceof Float) {
                Asserts.check((((Float)actual).floatValue() - ((Float)expected).floatValue() < 1.0E-4f ? 1 : 0) != 0, (String)ifEqual);
            } else {
                Asserts.check((boolean)Objects.equals(actual, expected), (String)ifEqual);
            }
        }
        catch (IllegalStateException e) {
            throw new AssertionError((Object)String.format("Failure: %s. Expected %s, but got %s.", ifEqual, expected, actual));
        }
    }

    public static <T> void assertNonEqual(T actual, T expected, String ifNonEqual) {
        try {
            if (actual instanceof Double) {
                Asserts.check(((Double)actual - (Double)expected >= 1.0E-4 ? 1 : 0) != 0, (String)ifNonEqual);
            } else if (actual instanceof Float) {
                Asserts.check((((Float)actual).floatValue() - ((Float)expected).floatValue() >= 1.0E-4f ? 1 : 0) != 0, (String)ifNonEqual);
            } else {
                Asserts.check((!Objects.equals(actual, expected) ? 1 : 0) != 0, (String)ifNonEqual);
            }
        }
        catch (IllegalStateException e) {
            throw new AssertionError((Object)String.format("Failure: %s. Expected not %s, but got %s.", ifNonEqual, expected, actual));
        }
    }

    public static <T> void assertNull(T actual, String ifNull) {
        try {
            Asserts.check((actual == null ? 1 : 0) != 0, (String)ifNull);
        }
        catch (IllegalStateException e) {
            throw new AssertionError((Object)String.format("Failure: %s. Expected to be null, but got %s.", ifNull, actual));
        }
    }

    public static <T> void assertNonNull(T actual, String ifNonNull) {
        try {
            Asserts.check((actual != null ? 1 : 0) != 0, (String)ifNonNull);
        }
        catch (IllegalStateException e) {
            throw new AssertionError((Object)String.format("Failure: %s. Expected to be non null, but got %s.", ifNonNull, actual));
        }
    }

    public static <T> CompoundTag serialize(Consumer<ValueOutput> deserializer) {
        return TestHelpers.serialize(deserializer, ValueDeseralizationContext.ofAllEnabled().holderLookupProvider());
    }

    public static <T> CompoundTag serialize(Consumer<ValueOutput> deserializer, HolderLookup.Provider holderLookup) {
        TagValueOutput valueOutput = TagValueOutput.createWithContext((ProblemReporter)new ProblemReporter(){

            public ProblemReporter forChild(ProblemReporter.PathElement p_421613_) {
                return this;
            }

            public void report(ProblemReporter.Problem p_422137_) {
            }
        }, (HolderLookup.Provider)holderLookup);
        deserializer.accept((ValueOutput)valueOutput);
        return valueOutput.buildResult();
    }

    public static <T> T deserialize(CompoundTag tag, Function<ValueInput, T> serializer) {
        return TestHelpers.deserialize(tag, serializer, ValueDeseralizationContext.ofAllEnabled().holderLookupProvider());
    }

    public static <T> T deserialize(CompoundTag tag, Function<ValueInput, T> serializer, HolderLookup.Provider holderLookup) {
        ValueInput valueInput = TagValueInput.create((ProblemReporter)new ProblemReporter(){

            public ProblemReporter forChild(ProblemReporter.PathElement p_421613_) {
                return this;
            }

            public void report(ProblemReporter.Problem p_422137_) {
            }
        }, (HolderLookup.Provider)holderLookup, (CompoundTag)tag);
        return serializer.apply(valueInput);
    }
}

